/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues;

import com.contrastsecurity.thirdparty.ojt.queues.BaseSpscLinkedArrayQueue;
import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeRefArrayAccess;

public class SpscUnboundedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscUnboundedArrayQueue(int n2) {
        int n3 = Math.max(Pow2.roundToPowerOfTwo(n2), 16);
        long l2 = n3 - 1;
        E[] EArray = UnsafeRefArrayAccess.allocateRefArray(n3 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.producerBufferLimit = l2 - 1L;
    }

    @Override
    final boolean offerColdPath(E[] EArray, long l2, long l3, long l4, E e2, MessagePassingQueue.Supplier<? extends E> supplier) {
        long l5 = (l2 + 1L) / 4L;
        long l6 = l3 + l5;
        if (null == UnsafeRefArrayAccess.lvRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l6, l2))) {
            this.producerBufferLimit = l6 - 1L;
            this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
        } else if (null == UnsafeRefArrayAccess.lvRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l3 + 1L, l2))) {
            this.writeToQueue(EArray, e2 == null ? supplier.get() : e2, l3, l4);
        } else {
            E[] EArray2 = UnsafeRefArrayAccess.allocateRefArray((int)(l2 + 2L));
            this.producerBuffer = EArray2;
            this.producerBufferLimit = l3 + l2 - 1L;
            this.linkOldToNew(l3, EArray, l4, EArray2, l4, e2 == null ? supplier.get() : e2);
        }
        return true;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return this.fill((MessagePassingQueue.Supplier)supplier, (int)this.producerMask);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

