/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues.atomic;

import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.atomic.AtomicQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.SpscLookAheadUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscGrowableAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    private final int maxQueueCapacity;
    private long lookAheadStep;

    public SpscGrowableAtomicArrayQueue(int n2) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(n2 / 8)), n2);
    }

    public SpscGrowableAtomicArrayQueue(int n2, int n3) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n3, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(n2, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(n3);
        int n4 = Pow2.roundToPowerOfTwo(n2);
        RangeUtil.checkLessThan(n4, this.maxQueueCapacity, "chunkCapacity");
        long l2 = n4 - 1;
        this.producerBuffer = atomicReferenceArray = AtomicQueueUtil.allocateRefArray(n4 + 1);
        this.producerMask = l2;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l2;
        this.producerBufferLimit = l2 - 1L;
        this.adjustLookAheadStep(n4);
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> atomicReferenceArray, long l2, long l3, int n2, E e2, MessagePassingQueue.Supplier<? extends E> supplier) {
        int n3;
        long l4 = this.lookAheadStep;
        if (l4 > 0L) {
            int n4 = AtomicQueueUtil.calcCircularRefElementOffset(l3 + l4, l2);
            if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, n4)) {
                this.producerBufferLimit = l3 + l4 - 1L;
                this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
                return true;
            }
            int n5 = this.maxQueueCapacity;
            if (l2 + 1L == (long)n5) {
                if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, n2)) {
                    this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
                    return true;
                }
                return false;
            }
            if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l3 + 1L, l2))) {
                this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
            } else {
                AtomicReferenceArray atomicReferenceArray2;
                this.producerBuffer = atomicReferenceArray2 = AtomicQueueUtil.allocateRefArray((int)(2L * (l2 + 1L) + 1L));
                this.producerMask = AtomicQueueUtil.length(atomicReferenceArray2) - 2;
                int n6 = AtomicQueueUtil.calcCircularRefElementOffset(l3, this.producerMask);
                this.linkOldToNew(l3, atomicReferenceArray, n2, atomicReferenceArray2, n6, e2 == null ? supplier.get() : e2);
                int n7 = (int)(this.producerMask + 1L);
                if (n7 == n5) {
                    long l5 = this.lvConsumerIndex();
                    this.lookAheadStep = -(l3 - l5);
                    this.producerBufferLimit = l5 + (long)n5;
                } else {
                    this.producerBufferLimit = l3 + this.producerMask - 1L;
                    this.adjustLookAheadStep(n7);
                }
            }
            return true;
        }
        long l6 = -l4;
        long l7 = this.lvConsumerIndex();
        int n8 = (int)(l3 - l7);
        if (n8 == (n3 = (int)l2 + 1)) {
            return false;
        }
        long l8 = this.producerBufferLimit - (long)n3 + l6;
        if (l7 >= l8) {
            this.adjustLookAheadStep(n3);
        } else {
            this.lookAheadStep = (int)(l7 - l8);
        }
        this.producerBufferLimit = l7 + (long)n3;
        this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
        return true;
    }

    private void adjustLookAheadStep(int n2) {
        this.lookAheadStep = SpscLookAheadUtil.computeLookAheadStep(n2);
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

