/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.queues.atomic;

import com.contrastsecurity.thirdparty.ojt.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.ojt.queues.atomic.AtomicQueueUtil;
import com.contrastsecurity.thirdparty.ojt.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import com.contrastsecurity.thirdparty.ojt.util.Pow2;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscUnboundedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    public SpscUnboundedAtomicArrayQueue(int n2) {
        AtomicReferenceArray atomicReferenceArray;
        int n3 = Math.max(Pow2.roundToPowerOfTwo(n2), 16);
        long l2 = n3 - 1;
        this.producerBuffer = atomicReferenceArray = AtomicQueueUtil.allocateRefArray(n3 + 1);
        this.producerMask = l2;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l2;
        this.producerBufferLimit = l2 - 1L;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> atomicReferenceArray, long l2, long l3, int n2, E e2, MessagePassingQueue.Supplier<? extends E> supplier) {
        long l4 = (l2 + 1L) / 4L;
        long l5 = l3 + l4;
        if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l5, l2))) {
            this.producerBufferLimit = l5 - 1L;
            this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
        } else if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l3 + 1L, l2))) {
            this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
        } else {
            AtomicReferenceArray atomicReferenceArray2;
            this.producerBuffer = atomicReferenceArray2 = AtomicQueueUtil.allocateRefArray((int)(l2 + 2L));
            this.producerBufferLimit = l3 + l2 - 1L;
            this.linkOldToNew(l3, atomicReferenceArray, n2, atomicReferenceArray2, n2, e2 == null ? supplier.get() : e2);
        }
        return true;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return this.fill((MessagePassingQueue.Supplier)supplier, (int)this.producerMask);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

