/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.util;

public final class Pow2 {
    public static final int MAX_POW2 = 0x40000000;

    public static int roundToPowerOfTwo(int n2) {
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("There is no larger power of 2 int for value:" + n2 + " since it exceeds 2^31.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Given value:" + n2 + ". Expecting value >= 0.");
        }
        int n3 = 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
        return n3;
    }

    public static boolean isPowerOfTwo(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    public static long align(long l2, int n2) {
        if (!Pow2.isPowerOfTwo(n2)) {
            throw new IllegalArgumentException("alignment must be a power of 2:" + n2);
        }
        return l2 + (long)(n2 - 1) & (long)(~(n2 - 1));
    }
}

