/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.util;

import com.contrastsecurity.agent.commons.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeAccess {
    public static final boolean SUPPORTS_GET_AND_SET_REF;
    public static final boolean SUPPORTS_GET_AND_ADD_LONG;
    public static final Unsafe UNSAFE;

    private static Unsafe getUnsafe() {
        Unsafe unsafe;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            try {
                Constructor constructor = Unsafe.class.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                unsafe = (Unsafe)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception3) {
                Throwables.throwIfCritical(exception3);
                Exception exception4 = exception3;
                throw new RuntimeException(exception4);
            }
        }
        return unsafe;
    }

    private static boolean hasGetAndSetSupport() {
        try {
            Unsafe.class.getMethod("getAndSetObject", Object.class, Long.TYPE, Object.class);
            return true;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return false;
        }
    }

    private static boolean hasGetAndAddLongSupport() {
        try {
            Unsafe.class.getMethod("getAndAddLong", Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            return false;
        }
    }

    public static long fieldOffset(Class clazz, String string) throws RuntimeException {
        try {
            return UNSAFE.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
    }

    static {
        UNSAFE = UnsafeAccess.getUnsafe();
        SUPPORTS_GET_AND_SET_REF = UnsafeAccess.hasGetAndSetSupport();
        SUPPORTS_GET_AND_ADD_LONG = UnsafeAccess.hasGetAndAddLongSupport();
    }
}

