/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.core;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.omp.core.MessagePack;
import com.contrastsecurity.thirdparty.omp.core.MessageStringCodingException;
import com.contrastsecurity.thirdparty.omp.core.Preconditions;
import com.contrastsecurity.thirdparty.omp.core.buffer.MessageBuffer;
import com.contrastsecurity.thirdparty.omp.core.buffer.MessageBufferOutput;
import com.contrastsecurity.thirdparty.omp.value.Value;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.time.Instant;

public class MessagePacker
implements Closeable,
Flushable {
    private static final boolean CORRUPTED_CHARSET_ENCODER;
    private final int smallStringOptimizationThreshold;
    private final int bufferFlushThreshold;
    private final boolean str8FormatSupport;
    protected MessageBufferOutput out;
    private MessageBuffer buffer;
    private int position;
    private long totalFlushBytes;
    private CharsetEncoder encoder;
    private static final int UTF_8_MAX_CHAR_SIZE = 6;
    private static final long NANOS_PER_SECOND = 1000000000L;

    protected MessagePacker(MessageBufferOutput messageBufferOutput, MessagePack.PackerConfig packerConfig) {
        this.out = Preconditions.checkNotNull(messageBufferOutput, "MessageBufferOutput is null");
        this.smallStringOptimizationThreshold = packerConfig.getSmallStringOptimizationThreshold();
        this.bufferFlushThreshold = packerConfig.getBufferFlushThreshold();
        this.str8FormatSupport = packerConfig.isStr8FormatSupport();
        this.position = 0;
        this.totalFlushBytes = 0L;
    }

    public MessageBufferOutput reset(MessageBufferOutput messageBufferOutput) throws IOException {
        MessageBufferOutput messageBufferOutput2 = Preconditions.checkNotNull(messageBufferOutput, "MessageBufferOutput is null");
        this.flush();
        MessageBufferOutput messageBufferOutput3 = this.out;
        this.out = messageBufferOutput2;
        this.totalFlushBytes = 0L;
        return messageBufferOutput3;
    }

    public long getTotalWrittenBytes() {
        return this.totalFlushBytes + (long)this.position;
    }

    public void clear() {
        this.position = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.flushBuffer();
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.out.close();
        }
    }

    private void flushBuffer() throws IOException {
        this.out.writeBuffer(this.position);
        this.buffer = null;
        this.totalFlushBytes += (long)this.position;
        this.position = 0;
    }

    private void ensureCapacity(int n2) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.out.next(n2);
        } else if (this.position + n2 >= this.buffer.size()) {
            this.flushBuffer();
            this.buffer = this.out.next(n2);
        }
    }

    private void writeByte(byte by) throws IOException {
        this.ensureCapacity(1);
        this.buffer.putByte(this.position++, by);
    }

    private void writeByteAndByte(byte by, byte by2) throws IOException {
        this.ensureCapacity(2);
        this.buffer.putByte(this.position++, by);
        this.buffer.putByte(this.position++, by2);
    }

    private void writeByteAndShort(byte by, short s2) throws IOException {
        this.ensureCapacity(3);
        this.buffer.putByte(this.position++, by);
        this.buffer.putShort(this.position, s2);
        this.position += 2;
    }

    private void writeByteAndInt(byte by, int n2) throws IOException {
        this.ensureCapacity(5);
        this.buffer.putByte(this.position++, by);
        this.buffer.putInt(this.position, n2);
        this.position += 4;
    }

    private void writeByteAndFloat(byte by, float f2) throws IOException {
        this.ensureCapacity(5);
        this.buffer.putByte(this.position++, by);
        this.buffer.putFloat(this.position, f2);
        this.position += 4;
    }

    private void writeByteAndDouble(byte by, double d2) throws IOException {
        this.ensureCapacity(9);
        this.buffer.putByte(this.position++, by);
        this.buffer.putDouble(this.position, d2);
        this.position += 8;
    }

    private void writeByteAndLong(byte by, long l2) throws IOException {
        this.ensureCapacity(9);
        this.buffer.putByte(this.position++, by);
        this.buffer.putLong(this.position, l2);
        this.position += 8;
    }

    private void writeShort(short s2) throws IOException {
        this.ensureCapacity(2);
        this.buffer.putShort(this.position, s2);
        this.position += 2;
    }

    private void writeInt(int n2) throws IOException {
        this.ensureCapacity(4);
        this.buffer.putInt(this.position, n2);
        this.position += 4;
    }

    private void writeLong(long l2) throws IOException {
        this.ensureCapacity(8);
        this.buffer.putLong(this.position, l2);
        this.position += 8;
    }

    public MessagePacker packNil() throws IOException {
        this.writeByte((byte)-64);
        return this;
    }

    public MessagePacker packBoolean(boolean bl2) throws IOException {
        this.writeByte(bl2 ? (byte)-61 : -62);
        return this;
    }

    public MessagePacker packByte(byte by) throws IOException {
        if (by < -32) {
            this.writeByteAndByte((byte)-48, by);
        } else {
            this.writeByte(by);
        }
        return this;
    }

    public MessagePacker packShort(short s2) throws IOException {
        if (s2 < -32) {
            if (s2 < -128) {
                this.writeByteAndShort((byte)-47, s2);
            } else {
                this.writeByteAndByte((byte)-48, (byte)s2);
            }
        } else if (s2 < 128) {
            this.writeByte((byte)s2);
        } else if (s2 < 256) {
            this.writeByteAndByte((byte)-52, (byte)s2);
        } else {
            this.writeByteAndShort((byte)-51, s2);
        }
        return this;
    }

    public MessagePacker packInt(int n2) throws IOException {
        if (n2 < -32) {
            if (n2 < Short.MIN_VALUE) {
                this.writeByteAndInt((byte)-46, n2);
            } else if (n2 < -128) {
                this.writeByteAndShort((byte)-47, (short)n2);
            } else {
                this.writeByteAndByte((byte)-48, (byte)n2);
            }
        } else if (n2 < 128) {
            this.writeByte((byte)n2);
        } else if (n2 < 256) {
            this.writeByteAndByte((byte)-52, (byte)n2);
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-51, (short)n2);
        } else {
            this.writeByteAndInt((byte)-50, n2);
        }
        return this;
    }

    public MessagePacker packLong(long l2) throws IOException {
        if (l2 < -32L) {
            if (l2 < -32768L) {
                if (l2 < Integer.MIN_VALUE) {
                    this.writeByteAndLong((byte)-45, l2);
                } else {
                    this.writeByteAndInt((byte)-46, (int)l2);
                }
            } else if (l2 < -128L) {
                this.writeByteAndShort((byte)-47, (short)l2);
            } else {
                this.writeByteAndByte((byte)-48, (byte)l2);
            }
        } else if (l2 < 128L) {
            this.writeByte((byte)l2);
        } else if (l2 < 65536L) {
            if (l2 < 256L) {
                this.writeByteAndByte((byte)-52, (byte)l2);
            } else {
                this.writeByteAndShort((byte)-51, (short)l2);
            }
        } else if (l2 < 0x100000000L) {
            this.writeByteAndInt((byte)-50, (int)l2);
        } else {
            this.writeByteAndLong((byte)-49, l2);
        }
        return this;
    }

    public MessagePacker packBigInteger(BigInteger bigInteger) throws IOException {
        if (bigInteger.bitLength() <= 63) {
            this.packLong(bigInteger.longValue());
        } else if (bigInteger.bitLength() == 64 && bigInteger.signum() == 1) {
            this.writeByteAndLong((byte)-49, bigInteger.longValue());
        } else {
            throw new IllegalArgumentException("MessagePack cannot serialize BigInteger larger than 2^64-1");
        }
        return this;
    }

    public MessagePacker packFloat(float f2) throws IOException {
        this.writeByteAndFloat((byte)-54, f2);
        return this;
    }

    public MessagePacker packDouble(double d2) throws IOException {
        this.writeByteAndDouble((byte)-53, d2);
        return this;
    }

    private void packStringWithGetBytes(String string) throws IOException {
        byte[] byArray = string.getBytes(MessagePack.UTF8);
        this.packRawStringHeader(byArray.length);
        this.addPayload(byArray);
    }

    private void prepareEncoder() {
        if (this.encoder == null) {
            this.encoder = MessagePack.UTF8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        this.encoder.reset();
    }

    private int encodeStringToBufferAt(int n2, String string) {
        this.prepareEncoder();
        ByteBuffer byteBuffer = this.buffer.sliceAsByteBuffer(n2, this.buffer.size() - n2);
        int n3 = byteBuffer.position();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        CoderResult coderResult = this.encoder.encode(charBuffer, byteBuffer, true);
        if (coderResult.isError()) {
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new MessageStringCodingException(characterCodingException);
            }
        }
        if (!coderResult.isUnderflow() || coderResult.isOverflow()) {
            return -1;
        }
        coderResult = this.encoder.flush(byteBuffer);
        if (!coderResult.isUnderflow()) {
            return -1;
        }
        return byteBuffer.position() - n3;
    }

    public MessagePacker packString(String string) throws IOException {
        if (string.length() <= 0) {
            this.packRawStringHeader(0);
            return this;
        }
        if (CORRUPTED_CHARSET_ENCODER || string.length() < this.smallStringOptimizationThreshold) {
            this.packStringWithGetBytes(string);
            return this;
        }
        if (string.length() < 256) {
            this.ensureCapacity(2 + string.length() * 6 + 1);
            int n2 = this.encodeStringToBufferAt(this.position + 2, string);
            if (n2 >= 0) {
                if (this.str8FormatSupport && n2 < 256) {
                    this.buffer.putByte(this.position++, (byte)-39);
                    this.buffer.putByte(this.position++, (byte)n2);
                    this.position += n2;
                } else {
                    if (n2 >= 65536) {
                        throw new IllegalArgumentException("Unexpected UTF-8 encoder state");
                    }
                    this.buffer.putMessageBuffer(this.position + 3, this.buffer, this.position + 2, n2);
                    this.buffer.putByte(this.position++, (byte)-38);
                    this.buffer.putShort(this.position, (short)n2);
                    this.position += 2;
                    this.position += n2;
                }
                return this;
            }
        } else if (string.length() < 65536) {
            this.ensureCapacity(3 + string.length() * 6 + 2);
            int n3 = this.encodeStringToBufferAt(this.position + 3, string);
            if (n3 >= 0) {
                if (n3 < 65536) {
                    this.buffer.putByte(this.position++, (byte)-38);
                    this.buffer.putShort(this.position, (short)n3);
                    this.position += 2;
                    this.position += n3;
                } else {
                    if ((long)n3 >= 0x100000000L) {
                        throw new IllegalArgumentException("Unexpected UTF-8 encoder state");
                    }
                    this.buffer.putMessageBuffer(this.position + 5, this.buffer, this.position + 3, n3);
                    this.buffer.putByte(this.position++, (byte)-37);
                    this.buffer.putInt(this.position, n3);
                    this.position += 4;
                    this.position += n3;
                }
                return this;
            }
        }
        this.packStringWithGetBytes(string);
        return this;
    }

    public MessagePacker packTimestamp(Instant instant) throws IOException {
        return this.packTimestamp(instant.getEpochSecond(), instant.getNano());
    }

    public MessagePacker packTimestamp(long l2) throws IOException {
        return this.packTimestamp(Instant.ofEpochMilli(l2));
    }

    public MessagePacker packTimestamp(long l2, int n2) throws IOException, ArithmeticException {
        long l3 = Math.addExact(l2, Math.floorDiv((long)n2, 1000000000L));
        long l4 = Math.floorMod((long)n2, 1000000000L);
        if (l3 >>> 34 == 0L) {
            long l5 = l4 << 34 | l3;
            if ((l5 & 0xFFFFFFFF00000000L) == 0L) {
                this.writeTimestamp32((int)l3);
            } else {
                this.writeTimestamp64(l5);
            }
        } else {
            this.writeTimestamp96(l3, (int)l4);
        }
        return this;
    }

    private void writeTimestamp32(int n2) throws IOException {
        this.ensureCapacity(6);
        this.buffer.putByte(this.position++, (byte)-42);
        this.buffer.putByte(this.position++, (byte)-1);
        this.buffer.putInt(this.position, n2);
        this.position += 4;
    }

    private void writeTimestamp64(long l2) throws IOException {
        this.ensureCapacity(10);
        this.buffer.putByte(this.position++, (byte)-41);
        this.buffer.putByte(this.position++, (byte)-1);
        this.buffer.putLong(this.position, l2);
        this.position += 8;
    }

    private void writeTimestamp96(long l2, int n2) throws IOException {
        this.ensureCapacity(15);
        this.buffer.putByte(this.position++, (byte)-57);
        this.buffer.putByte(this.position++, (byte)12);
        this.buffer.putByte(this.position++, (byte)-1);
        this.buffer.putInt(this.position, n2);
        this.position += 4;
        this.buffer.putLong(this.position, l2);
        this.position += 8;
    }

    public MessagePacker packArrayHeader(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("array size must be >= 0");
        }
        if (n2 < 16) {
            this.writeByte((byte)(0xFFFFFF90 | n2));
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-36, (short)n2);
        } else {
            this.writeByteAndInt((byte)-35, n2);
        }
        return this;
    }

    public MessagePacker packMapHeader(int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("map size must be >= 0");
        }
        if (n2 < 16) {
            this.writeByte((byte)(0xFFFFFF80 | n2));
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-34, (short)n2);
        } else {
            this.writeByteAndInt((byte)-33, n2);
        }
        return this;
    }

    public MessagePacker packValue(Value value) throws IOException {
        value.writeTo(this);
        return this;
    }

    public MessagePacker packExtensionTypeHeader(byte by, int n2) throws IOException {
        if (n2 < 256) {
            if (n2 > 0 && (n2 & n2 - 1) == 0) {
                if (n2 == 1) {
                    this.writeByteAndByte((byte)-44, by);
                } else if (n2 == 2) {
                    this.writeByteAndByte((byte)-43, by);
                } else if (n2 == 4) {
                    this.writeByteAndByte((byte)-42, by);
                } else if (n2 == 8) {
                    this.writeByteAndByte((byte)-41, by);
                } else if (n2 == 16) {
                    this.writeByteAndByte((byte)-40, by);
                } else {
                    this.writeByteAndByte((byte)-57, (byte)n2);
                    this.writeByte(by);
                }
            } else {
                this.writeByteAndByte((byte)-57, (byte)n2);
                this.writeByte(by);
            }
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-56, (short)n2);
            this.writeByte(by);
        } else {
            this.writeByteAndInt((byte)-55, n2);
            this.writeByte(by);
        }
        return this;
    }

    public MessagePacker packBinaryHeader(int n2) throws IOException {
        if (n2 < 256) {
            this.writeByteAndByte((byte)-60, (byte)n2);
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-59, (short)n2);
        } else {
            this.writeByteAndInt((byte)-58, n2);
        }
        return this;
    }

    public MessagePacker packRawStringHeader(int n2) throws IOException {
        if (n2 < 32) {
            this.writeByte((byte)(0xFFFFFFA0 | n2));
        } else if (this.str8FormatSupport && n2 < 256) {
            this.writeByteAndByte((byte)-39, (byte)n2);
        } else if (n2 < 65536) {
            this.writeByteAndShort((byte)-38, (short)n2);
        } else {
            this.writeByteAndInt((byte)-37, n2);
        }
        return this;
    }

    public MessagePacker writePayload(byte[] byArray) throws IOException {
        return this.writePayload(byArray, 0, byArray.length);
    }

    public MessagePacker writePayload(byte[] byArray, int n2, int n3) throws IOException {
        if (this.buffer == null || this.buffer.size() - this.position < n3 || n3 > this.bufferFlushThreshold) {
            this.flush();
            this.out.write(byArray, n2, n3);
            this.totalFlushBytes += (long)n3;
        } else {
            this.buffer.putBytes(this.position, byArray, n2, n3);
            this.position += n3;
        }
        return this;
    }

    public MessagePacker addPayload(byte[] byArray) throws IOException {
        return this.addPayload(byArray, 0, byArray.length);
    }

    public MessagePacker addPayload(byte[] byArray, int n2, int n3) throws IOException {
        if (this.buffer == null || this.buffer.size() - this.position < n3 || n3 > this.bufferFlushThreshold) {
            this.flush();
            this.out.add(byArray, n2, n3);
            this.totalFlushBytes += (long)n3;
        } else {
            this.buffer.putBytes(this.position, byArray, n2, n3);
            this.position += n3;
        }
        return this;
    }

    static {
        boolean bl2 = false;
        try {
            Class<?> clazz = Class.forName("android.os.Build$VERSION");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Field field = clazz.getField("SDK_INT");
            int n2 = field.getInt(obj);
            if (n2 >= 14 && n2 < 21) {
                bl2 = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwables.throwIfCritical(invocationTargetException);
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            invocationTargetException2.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        CORRUPTED_CHARSET_ENCODER = bl2;
    }
}

