/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.ast;

import com.contrastsecurity.thirdparty.omv2.CompileException;
import com.contrastsecurity.thirdparty.omv2.MVEL;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.ast.ASTNode;
import com.contrastsecurity.thirdparty.omv2.ast.Assignment;
import com.contrastsecurity.thirdparty.omv2.compiler.CompiledAccExpression;
import com.contrastsecurity.thirdparty.omv2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.util.ArrayTools;
import com.contrastsecurity.thirdparty.omv2.util.ParseTools;

public class IndexedAssignmentNode
extends ASTNode
implements Assignment {
    private String assignmentVar;
    private String name;
    private int register;
    private transient CompiledAccExpression accExpr;
    private char[] indexTarget;
    private char[] index;
    private char[] stmt;
    private ExecutableStatement statement;
    private boolean col = false;

    public IndexedAssignmentNode(char[] cArray, int n2, int n3, int n4, int n5, String string, int n6, ParserContext parserContext) {
        super(parserContext);
        this.expr = cArray;
        this.start = n2;
        this.offset = n3;
        this.register = n6;
        if (n5 != -1) {
            this.name = string;
            ParseTools.checkNameSafety(this.name);
            this.stmt = ParseTools.createShortFormOperativeAssignment(string, cArray, n2, n3, n5);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt, parserContext);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int n7 = ParseTools.find(cArray, n2, n3, '=');
            if (n7 != -1) {
                this.name = ParseTools.createStringTrimmed(cArray, n2, n7 - n2);
                this.assignmentVar = string;
                this.start = ParseTools.skipWhitespace(cArray, n7 + 1);
                if (this.start >= n2 + n3) {
                    throw new CompileException("unexpected end of statement", cArray, n7 + 1);
                }
                this.offset = n3 - (this.start - n2);
                this.stmt = ParseTools.subset(cArray, this.start, this.offset);
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(cArray, this.start, this.offset, parserContext);
                this.egressType = this.statement.getKnownEgressType();
                this.indexTarget = this.name.toCharArray();
                short s2 = (short)ArrayTools.findFirst('[', 0, this.name.length(), this.indexTarget);
                this.endOfName = s2;
                this.col = s2 > 0;
                if (this.col) {
                    if (((this.fields |= 0x100) & 0x10) != 0) {
                        this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget, parserContext);
                    }
                    this.name = this.name.substring(0, this.endOfName);
                    this.index = ParseTools.subset(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
                }
                ParseTools.checkNameSafety(this.name);
            } else {
                this.name = new String(cArray);
                ParseTools.checkNameSafety(this.name);
                this.assignmentVar = string;
            }
        }
        if ((n4 & 0x10) != 0) {
            parserContext.addVariable(string, this.egressType);
        }
    }

    public IndexedAssignmentNode(char[] cArray, int n2, int n3, int n4, int n5, ParserContext parserContext) {
        this(cArray, n2, n3, n4, -1, null, n5, parserContext);
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (this.accExpr == null && this.indexTarget != null) {
            this.accExpr = (CompiledAccExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            Object object3 = object;
            object = this.statement.getValue(object, object2, variableResolverFactory);
            this.accExpr.setValue(object3, object2, variableResolverFactory, object);
        } else if (this.statement != null) {
            if (variableResolverFactory.isIndexedFactory()) {
                object = this.statement.getValue(object, object2, variableResolverFactory);
                variableResolverFactory.createIndexedVariable(this.register, this.name, object);
            } else {
                object = this.statement.getValue(object, object2, variableResolverFactory);
                variableResolverFactory.createVariable(this.name, object);
            }
        } else {
            if (variableResolverFactory.isIndexedFactory()) {
                variableResolverFactory.createIndexedVariable(this.register, this.name, null);
            } else {
                variableResolverFactory.createVariable(this.name, this.statement.getValue(object, object2, variableResolverFactory));
            }
            return Void.class;
        }
        return object;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        ParseTools.checkNameSafety(this.name);
        if (this.col) {
            object = MVEL.eval(this.stmt, object, variableResolverFactory);
            MVEL.setProperty(variableResolverFactory.getIndexedVariableResolver(this.register).getValue(), new String(this.index), object);
        } else {
            object = MVEL.eval(this.stmt, object, variableResolverFactory);
            variableResolverFactory.createIndexedVariable(this.register, this.name, object);
        }
        return object;
    }

    public String getAssignmentVar() {
        return this.assignmentVar;
    }

    public String getVarName() {
        return this.name;
    }

    public char[] getExpression() {
        return this.stmt;
    }

    public int getRegister() {
        return this.register;
    }

    public void setRegister(int n2) {
        this.register = n2;
    }

    public boolean isAssignment() {
        return true;
    }

    public String getAbsoluteName() {
        return this.name;
    }

    public boolean isNewDeclaration() {
        return false;
    }

    public void setValueStatement(ExecutableStatement executableStatement) {
        this.statement = executableStatement;
    }
}

