/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.ast;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.omv2.CompileException;
import com.contrastsecurity.thirdparty.omv2.MVEL;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.ast.BlockNode;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.util.ExecutionStack;
import com.contrastsecurity.thirdparty.omv2.util.ParseTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stacklang
extends BlockNode {
    List<Instruction> instructionList;
    ParserContext pCtx;
    static final Map<String, Integer> opcodes = new HashMap<String, Integer>();

    public Stacklang(char[] cArray, int n2, int n3, int n4, ParserContext parserContext) {
        super(parserContext);
        this.expr = cArray;
        this.blockStart = n2;
        this.blockOffset = n3;
        this.fields = n4 | 0x400000;
        String[] stringArray = new String(cArray, n2, n3).split(";");
        this.instructionList = new ArrayList<Instruction>(stringArray.length);
        for (String string : stringArray) {
            this.instructionList.add(Stacklang.parseInstruction(string.trim()));
        }
        this.pCtx = parserContext;
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        ExecutionStack executionStack = new ExecutionStack();
        executionStack.push(this.getReducedValue(executionStack, object2, variableResolverFactory));
        if (executionStack.isReduceable()) {
            while (true) {
                executionStack.op();
                if (!executionStack.isReduceable()) break;
                executionStack.xswap();
            }
        }
        return executionStack.peek();
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        ExecutionStack executionStack = (ExecutionStack)object;
        int n2 = this.instructionList.size();
        block29: for (int i2 = 0; i2 < n2; ++i2) {
            Instruction instruction = this.instructionList.get(i2);
            System.out.println(executionStack.toString() + " >> " + instruction.opcode + ":" + instruction.expr);
            switch (instruction.opcode) {
                case 109: {
                    if (instruction.cache == null) {
                        instruction.cache = variableResolverFactory.createVariable(instruction.expr, executionStack.peek());
                        continue block29;
                    }
                    ((VariableResolver)instruction.cache).setValue(executionStack.peek());
                    continue block29;
                }
                case 104: {
                    if (instruction.cache == null) {
                        instruction.cache = variableResolverFactory.getVariableResolver(instruction.expr);
                    }
                    executionStack.push(((VariableResolver)instruction.cache).getValue());
                    continue block29;
                }
                case 107: {
                    Object[] objectArray;
                    try {
                        if (executionStack.isEmpty() || !(executionStack.peek() instanceof Class)) {
                            throw new CompileException("getfield without class", this.expr, this.blockStart);
                        }
                        if (instruction.cache == null) {
                            objectArray = ((Class)executionStack.pop()).getField(instruction.expr);
                            instruction.cache = objectArray;
                        } else {
                            executionStack.discard();
                            objectArray = (Field)instruction.cache;
                        }
                        executionStack.push(objectArray.get(executionStack.pop()));
                        continue block29;
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        objectArray = exception;
                        throw new CompileException("field access error", this.expr, this.blockStart, (Throwable)objectArray);
                    }
                }
                case 108: {
                    Object object3;
                    Object[] objectArray;
                    try {
                        if (executionStack.isEmpty() || !(executionStack.peek() instanceof Class)) {
                            throw new CompileException("storefield without class", this.expr, this.blockStart);
                        }
                        objectArray = (Class)executionStack.pop();
                        object3 = executionStack.pop();
                        objectArray.getField(instruction.expr).set(executionStack.pop(), object3);
                        executionStack.push(object3);
                        continue block29;
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        objectArray = exception;
                        throw new CompileException("field access error", this.expr, this.blockStart, (Throwable)objectArray);
                    }
                }
                case 105: {
                    try {
                        if (instruction.cache == null) {
                            instruction.cache = ParseTools.createClass(instruction.expr, this.pCtx);
                        }
                        executionStack.push(instruction.cache);
                        continue block29;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new CompileException("error", this.expr, this.blockStart, classNotFoundException);
                    }
                }
                case 106: {
                    Method method;
                    Object object4;
                    Object object3 = new ExecutionStack();
                    while (!executionStack.isEmpty() && !(executionStack.peek() instanceof Class)) {
                        ((ExecutionStack)object3).push(executionStack.pop());
                    }
                    if (executionStack.isEmpty()) {
                        throw new CompileException("invoke without class", this.expr, this.blockStart);
                    }
                    Object[] objectArray = new Object[((ExecutionStack)object3).size()];
                    int n3 = 0;
                    while (!((ExecutionStack)object3).isEmpty()) {
                        objectArray[n3] = ((ExecutionStack)object3).pop();
                        ++n3;
                    }
                    if ("<init>".equals(instruction.expr)) {
                        Constructor constructor;
                        if (instruction.cache == null) {
                            constructor = ParseTools.getBestConstructorCandidate(objectArray, (Class)executionStack.pop(), false);
                            instruction.cache = constructor;
                        } else {
                            constructor = (Constructor)instruction.cache;
                        }
                        try {
                            executionStack.push(constructor.newInstance(objectArray));
                            continue block29;
                        }
                        catch (Exception exception) {
                            Throwables.throwIfCritical(exception);
                            object4 = exception;
                            throw new CompileException("instantiation error", this.expr, this.blockStart, (Throwable)object4);
                        }
                    }
                    if (instruction.cache == null) {
                        object4 = (Class)executionStack.pop();
                        method = ParseTools.getBestCandidate(objectArray, instruction.expr, (Class)object4, ((Class)object4).getDeclaredMethods(), false);
                        instruction.cache = method;
                    } else {
                        executionStack.discard();
                        method = (Method)instruction.cache;
                    }
                    try {
                        executionStack.push(method.invoke(executionStack.isEmpty() ? null : executionStack.pop(), objectArray));
                        continue block29;
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        object4 = exception;
                        throw new CompileException("invokation error", this.expr, this.blockStart, (Throwable)object4);
                    }
                }
                case 102: {
                    if (instruction.cache == null) {
                        instruction.cache = MVEL.eval(instruction.expr, object, variableResolverFactory);
                    }
                    executionStack.push(instruction.cache);
                    continue block29;
                }
                case 103: {
                    executionStack.pop();
                    continue block29;
                }
                case 110: {
                    executionStack.dup();
                    continue block29;
                }
                case 111: {
                    continue block29;
                }
                case 113: {
                    if (!executionStack.popBoolean().booleanValue()) continue block29;
                }
                case 112: {
                    Object object4;
                    if (instruction.cache != null) {
                        i2 = (Integer)instruction.cache;
                        continue block29;
                    }
                    for (int i3 = 0; i3 < this.instructionList.size(); ++i3) {
                        object4 = this.instructionList.get(i3);
                        if (((Instruction)object4).opcode != 111 || !instruction.expr.equals(((Instruction)object4).expr)) continue;
                        i2 = i3;
                        instruction.cache = i2;
                        continue block29;
                    }
                    continue block29;
                }
                case 18: {
                    executionStack.push(executionStack.pop().equals(executionStack.pop()));
                    continue block29;
                }
                case 19: {
                    executionStack.push(!executionStack.pop().equals(executionStack.pop()));
                    continue block29;
                }
                case 114: {
                    executionStack.op();
                    continue block29;
                }
                case 116: {
                    executionStack.xswap2();
                    continue block29;
                }
                case 115: {
                    Object object5 = executionStack.pop();
                    Object object4 = executionStack.pop();
                    executionStack.push(object5);
                    executionStack.push(object4);
                }
            }
        }
        return executionStack.pop();
    }

    private static Instruction parseInstruction(String string) {
        String string2;
        int n2 = string.indexOf(32);
        Instruction instruction = new Instruction();
        String string3 = string2 = n2 == -1 ? string : string.substring(0, n2);
        if (opcodes.containsKey(string2)) {
            instruction.opcode = opcodes.get(string2);
        }
        if (string2 != string) {
            instruction.expr = string.substring(n2 + 1);
        }
        return instruction;
    }

    static {
        opcodes.put("push", 102);
        opcodes.put("pop", 103);
        opcodes.put("load", 104);
        opcodes.put("ldtype", 105);
        opcodes.put("invoke", 106);
        opcodes.put("store", 109);
        opcodes.put("getfield", 107);
        opcodes.put("storefield", 108);
        opcodes.put("dup", 110);
        opcodes.put("jump", 112);
        opcodes.put("jumpif", 113);
        opcodes.put("label", 111);
        opcodes.put("eq", 18);
        opcodes.put("ne", 19);
        opcodes.put("reduce", 114);
        opcodes.put("xswap", 116);
        opcodes.put("swap", 115);
    }

    private static class Instruction {
        int opcode;
        String expr;
        Object cache;

        private Instruction() {
        }
    }
}

