/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class BigIntegerCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(Object.class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger(String.valueOf(object));
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public BigInteger convert(Object object) {
                return (BigInteger)object;
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public BigInteger convert(Object object) {
                return ((BigDecimal)object).toBigInteger();
            }
        });
        CNV.put(String.class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger((String)object);
            }
        });
        CNV.put(Short.class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger(String.valueOf(object));
            }
        });
        CNV.put(Long.class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger(String.valueOf(object));
            }
        });
        CNV.put(Integer.class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger(String.valueOf(object));
            }
        });
        CNV.put(String.class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger((String)object);
            }
        });
        CNV.put(char[].class, new Converter(){

            public BigInteger convert(Object object) {
                return new BigInteger(new String((char[])object));
            }
        });
    }
}

