/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.util.HashMap;
import java.util.Map;

public class ByteCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object object) {
            return Byte.parseByte((String)object);
        }
    };

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(Byte.class, new Converter(){

            public Object convert(Object object) {
                return new Byte((Byte)object);
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object object) {
                return ((Integer)object).byteValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Object convert(Object object) {
                return ((Long)object).byteValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Object convert(Object object) {
                return ((Double)object).byteValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            public Object convert(Object object) {
                return ((Float)object).byteValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            public Object convert(Object object) {
                return ((Short)object).byteValue();
            }
        });
    }
}

