/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class ShortCH
implements ConversionHandler {
    private static final Short TRUE = 1;
    private static final Short FALSE = 0;
    private static Converter stringConverter = new Converter(){

        public Short convert(Object object) {
            return Short.parseShort((String)object);
        }
    };
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Short.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Short convert(Object object) {
                return ((BigDecimal)object).shortValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Short convert(Object object) {
                return ((BigInteger)object).shortValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            public Object convert(Object object) {
                return object;
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Short convert(Object object) {
                if ((Integer)object > Short.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Integer to Short since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Integer)object).shortValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            public Short convert(Object object) {
                if (((Float)object).floatValue() > 32767.0f) {
                    throw new ConversionException("cannot coerce Float to Short since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Float)object).shortValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Short convert(Object object) {
                if ((Double)object > 32767.0) {
                    throw new ConversionException("cannot coerce Double to Short since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Double)object).shortValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Short convert(Object object) {
                if ((Long)object > 32767L) {
                    throw new ConversionException("cannot coerce Integer to Short since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Integer.");
                }
                return ((Long)object).shortValue();
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Short convert(Object object) {
                if (((Boolean)object).booleanValue()) {
                    return TRUE;
                }
                return FALSE;
            }
        });
    }
}

