/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.integration.impl;

import com.contrastsecurity.thirdparty.omv2.UnresolveablePropertyException;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVariableResolverFactory
implements VariableResolverFactory {
    protected Map<String, VariableResolver> variableResolvers = new HashMap<String, VariableResolver>();
    protected VariableResolverFactory nextFactory;
    protected int indexOffset = 0;
    protected String[] indexedVariableNames;
    protected VariableResolver[] indexedVariableResolvers;
    private boolean tiltFlag;

    @Override
    public VariableResolverFactory getNextFactory() {
        return this.nextFactory;
    }

    @Override
    public VariableResolverFactory setNextFactory(VariableResolverFactory variableResolverFactory) {
        this.nextFactory = variableResolverFactory;
        return this.nextFactory;
    }

    @Override
    public VariableResolver getVariableResolver(String string) {
        if (this.isResolveable(string)) {
            if (this.variableResolvers.containsKey(string)) {
                return this.variableResolvers.get(string);
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(string);
            }
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + string + "'");
    }

    public boolean isNextResolveable(String string) {
        return this.nextFactory != null && this.nextFactory.isResolveable(string);
    }

    public void appendFactory(VariableResolverFactory variableResolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = variableResolverFactory;
        } else {
            VariableResolverFactory variableResolverFactory2 = this.nextFactory;
            while (variableResolverFactory2.getNextFactory() != null) {
                variableResolverFactory2 = variableResolverFactory2.getNextFactory();
            }
            variableResolverFactory2.setNextFactory(this.nextFactory);
        }
    }

    public void insertFactory(VariableResolverFactory variableResolverFactory) {
        if (this.nextFactory == null) {
            this.nextFactory = variableResolverFactory;
        } else {
            this.nextFactory = variableResolverFactory;
            variableResolverFactory.setNextFactory(this.nextFactory);
        }
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            return new HashSet<String>(this.variableResolvers.keySet());
        }
        HashSet<String> hashSet = new HashSet<String>(this.variableResolvers.keySet());
        hashSet.addAll(this.nextFactory.getKnownVariables());
        return hashSet;
    }

    @Override
    public VariableResolver createIndexedVariable(int n2, String string, Object object) {
        if (this.nextFactory != null) {
            return this.nextFactory.createIndexedVariable(n2 - this.indexOffset, string, object);
        }
        throw new RuntimeException("cannot create indexed variable: " + string + "(" + n2 + "). operation not supported by resolver: " + this.getClass().getName());
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int n2) {
        if (this.nextFactory != null) {
            return this.nextFactory.getIndexedVariableResolver(n2 - this.indexOffset);
        }
        throw new RuntimeException("cannot access indexed variable: " + n2 + ".  operation not supported by resolver: " + this.getClass().getName());
    }

    @Override
    public VariableResolver createIndexedVariable(int n2, String string, Object object, Class<?> clazz) {
        if (this.nextFactory != null) {
            return this.nextFactory.createIndexedVariable(n2 - this.indexOffset, string, object, clazz);
        }
        throw new RuntimeException("cannot access indexed variable: " + string + "(" + n2 + ").  operation not supported by resolver.: " + this.getClass().getName());
    }

    public Map<String, VariableResolver> getVariableResolvers() {
        return this.variableResolvers;
    }

    public void setVariableResolvers(Map<String, VariableResolver> map) {
        this.variableResolvers = map;
    }

    public String[] getIndexedVariableNames() {
        return this.indexedVariableNames;
    }

    public void setIndexedVariableNames(String[] stringArray) {
        this.indexedVariableNames = stringArray;
    }

    @Override
    public int variableIndexOf(String string) {
        if (this.indexedVariableNames != null) {
            for (int i2 = 0; i2 < this.indexedVariableNames.length; ++i2) {
                if (!string.equals(this.indexedVariableNames[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public VariableResolver setIndexedVariableResolver(int n2, VariableResolver variableResolver) {
        if (this.indexedVariableResolvers == null) {
            VariableResolver[] variableResolverArray = new VariableResolver[this.indexedVariableNames.length];
            this.indexedVariableResolvers = variableResolverArray;
            VariableResolver variableResolver2 = variableResolver;
            variableResolverArray[n2 - this.indexOffset] = variableResolver2;
            return variableResolver2;
        }
        VariableResolver variableResolver3 = variableResolver;
        this.indexedVariableResolvers[n2 - this.indexOffset] = variableResolver3;
        return variableResolver3;
    }

    @Override
    public boolean isIndexedFactory() {
        return false;
    }

    @Override
    public boolean tiltFlag() {
        return this.tiltFlag;
    }

    @Override
    public void setTiltFlag(boolean bl2) {
        this.tiltFlag = bl2;
        if (this.nextFactory != null) {
            this.nextFactory.setTiltFlag(bl2);
        }
    }
}

