/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import com.contrastsecurity.thirdparty.omv2.util.NullType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibilityStrategy {
    public static CompatibilityEvaluator compatibilityEvaluator = new DefaultCompatibilityEvaluator();

    private CompatibilityStrategy() {
    }

    public static boolean areEqualityCompatible(Class<?> clazz, Class<?> clazz2) {
        return compatibilityEvaluator.areEqualityCompatible(clazz, clazz2);
    }

    public static boolean areComparisonCompatible(Class<?> clazz, Class<?> clazz2) {
        return compatibilityEvaluator.areComparisonCompatible(clazz, clazz2);
    }

    public static void setCompatibilityEvaluator(CompatibilityEvaluator compatibilityEvaluator) {
        CompatibilityStrategy.compatibilityEvaluator = compatibilityEvaluator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultCompatibilityEvaluator
    implements CompatibilityEvaluator {
        @Override
        public boolean areEqualityCompatible(Class<?> clazz, Class<?> clazz2) {
            if (clazz == NullType.class || clazz2 == NullType.class) {
                return true;
            }
            if (clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz)) {
                return true;
            }
            if (this.isBoxedNumber(clazz, false) && this.isBoxedNumber(clazz2, true)) {
                return true;
            }
            if (clazz.isPrimitive()) {
                return clazz2.isPrimitive() || this.arePrimitiveCompatible(clazz, clazz2, true);
            }
            if (clazz2.isPrimitive()) {
                return this.arePrimitiveCompatible(clazz2, clazz, false);
            }
            return false;
        }

        @Override
        public boolean areComparisonCompatible(Class<?> clazz, Class<?> clazz2) {
            return this.areEqualityCompatible(clazz, clazz2);
        }

        private boolean arePrimitiveCompatible(Class<?> clazz, Class<?> clazz2, boolean bl2) {
            if (clazz == Boolean.TYPE) {
                return clazz2 == Boolean.class;
            }
            if (clazz == Integer.TYPE) {
                return this.isBoxedNumber(clazz2, bl2);
            }
            if (clazz == Long.TYPE) {
                return this.isBoxedNumber(clazz2, bl2);
            }
            if (clazz == Double.TYPE) {
                return this.isBoxedNumber(clazz2, bl2);
            }
            if (clazz == Float.TYPE) {
                return this.isBoxedNumber(clazz2, bl2);
            }
            if (clazz == Character.TYPE) {
                return clazz2 == Character.class;
            }
            if (clazz == Byte.TYPE) {
                return clazz2 == Byte.class;
            }
            if (clazz == Short.TYPE) {
                return clazz2 == Short.class;
            }
            return false;
        }

        private boolean isBoxedNumber(Class<?> clazz, boolean bl2) {
            return Number.class.isAssignableFrom(clazz) || bl2 && clazz == String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CompatibilityEvaluator {
        public boolean areEqualityCompatible(Class<?> var1, Class<?> var2);

        public boolean areComparisonCompatible(Class<?> var1, Class<?> var2);
    }
}

