/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oobjw.asm;

import com.contrastsecurity.thirdparty.oobjw.asm.ByteVector;
import com.contrastsecurity.thirdparty.oobjw.asm.ClassReader;
import com.contrastsecurity.thirdparty.oobjw.asm.ClassWriter;
import com.contrastsecurity.thirdparty.oobjw.asm.Label;
import com.contrastsecurity.thirdparty.oobjw.asm.SymbolTable;

public class Attribute {
    public final String type;
    private ByteVector cachedContent;
    Attribute nextAttribute;

    protected Attribute(String string) {
        this.type = string;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    @Deprecated
    protected Label[] getLabels() {
        return new Label[0];
    }

    protected Attribute read(ClassReader classReader, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        Attribute attribute = new Attribute(this.type);
        attribute.cachedContent = new ByteVector(classReader.readBytes(n2, n3));
        return attribute;
    }

    public static Attribute read(Attribute attribute, ClassReader classReader, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        return attribute.read(classReader, n2, n3, cArray, n4, labelArray);
    }

    public static Label readLabel(ClassReader classReader, int n2, Label[] labelArray) {
        return classReader.readLabel(n2, labelArray);
    }

    private ByteVector maybeWrite(ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        if (this.cachedContent == null) {
            this.cachedContent = this.write(classWriter, byArray, n2, n3, n4);
        }
        return this.cachedContent;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        return this.cachedContent;
    }

    public static byte[] write(Attribute attribute, ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        ByteVector byteVector = attribute.maybeWrite(classWriter, byArray, n2, n3, n4);
        byte[] byArray2 = new byte[byteVector.length];
        System.arraycopy(byteVector.data, 0, byArray2, 0, byteVector.length);
        return byArray2;
    }

    final int getAttributeCount() {
        int n2 = 0;
        Attribute attribute = this;
        while (attribute != null) {
            ++n2;
            attribute = attribute.nextAttribute;
        }
        return n2;
    }

    final int computeAttributesSize(SymbolTable symbolTable) {
        byte[] byArray = null;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        return this.computeAttributesSize(symbolTable, byArray, 0, -1, -1);
    }

    final int computeAttributesSize(SymbolTable symbolTable, byte[] byArray, int n2, int n3, int n4) {
        ClassWriter classWriter = symbolTable.classWriter;
        int n5 = 0;
        Attribute attribute = this;
        while (attribute != null) {
            symbolTable.addConstantUtf8(attribute.type);
            n5 += 6 + attribute.maybeWrite((ClassWriter)classWriter, (byte[])byArray, (int)n2, (int)n3, (int)n4).length;
            attribute = attribute.nextAttribute;
        }
        return n5;
    }

    static int computeAttributesSize(SymbolTable symbolTable, int n2, int n3) {
        int n4 = 0;
        if ((n2 & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            symbolTable.addConstantUtf8("Synthetic");
            n4 += 6;
        }
        if (n3 != 0) {
            symbolTable.addConstantUtf8("Signature");
            n4 += 8;
        }
        if ((n2 & 0x20000) != 0) {
            symbolTable.addConstantUtf8("Deprecated");
            n4 += 6;
        }
        return n4;
    }

    final void putAttributes(SymbolTable symbolTable, ByteVector byteVector) {
        byte[] byArray = null;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        this.putAttributes(symbolTable, byArray, 0, -1, -1, byteVector);
    }

    final void putAttributes(SymbolTable symbolTable, byte[] byArray, int n2, int n3, int n4, ByteVector byteVector) {
        ClassWriter classWriter = symbolTable.classWriter;
        Attribute attribute = this;
        while (attribute != null) {
            ByteVector byteVector2 = attribute.maybeWrite(classWriter, byArray, n2, n3, n4);
            byteVector.putShort(symbolTable.addConstantUtf8(attribute.type)).putInt(byteVector2.length);
            byteVector.putByteArray(byteVector2.data, 0, byteVector2.length);
            attribute = attribute.nextAttribute;
        }
    }

    static void putAttributes(SymbolTable symbolTable, int n2, int n3, ByteVector byteVector) {
        if ((n2 & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            byteVector.putShort(symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (n3 != 0) {
            byteVector.putShort(symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(n3);
        }
        if ((n2 & 0x20000) != 0) {
            byteVector.putShort(symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
    }

    static final class Set {
        private static final int SIZE_INCREMENT = 6;
        private int size;
        private Attribute[] data = new Attribute[6];

        Set() {
        }

        void addAttributes(Attribute attribute) {
            Attribute attribute2 = attribute;
            while (attribute2 != null) {
                if (!this.contains(attribute2)) {
                    this.add(attribute2);
                }
                attribute2 = attribute2.nextAttribute;
            }
        }

        Attribute[] toArray() {
            Attribute[] attributeArray = new Attribute[this.size];
            System.arraycopy(this.data, 0, attributeArray, 0, this.size);
            return attributeArray;
        }

        private boolean contains(Attribute attribute) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!this.data[i2].type.equals(attribute.type)) continue;
                return true;
            }
            return false;
        }

        private void add(Attribute attribute) {
            if (this.size >= this.data.length) {
                Attribute[] attributeArray = new Attribute[this.data.length + 6];
                System.arraycopy(this.data, 0, attributeArray, 0, this.size);
                this.data = attributeArray;
            }
            this.data[this.size++] = attribute;
        }
    }
}

