/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis;

import com.contrastsecurity.thirdparty.oobjw.asm.Type;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.AnalyzerException;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.BasicValue;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.BasicVerifier;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVerifier
extends BasicVerifier {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List<Type> currentClassInterfaces;
    private final boolean isInterface;
    private ClassLoader loader = this.getClass().getClassLoader();

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type type, Type type2, boolean bl2) {
        this(type, type2, null, bl2);
    }

    public SimpleVerifier(Type type, Type type2, List<Type> list, boolean bl2) {
        this(589824, type, type2, list, bl2);
        if (this.getClass() != SimpleVerifier.class) {
            throw new IllegalStateException();
        }
    }

    protected SimpleVerifier(int n2, Type type, Type type2, List<Type> list, boolean bl2) {
        super(n2);
        this.currentClass = type;
        this.currentSuperClass = type2;
        this.currentClassInterfaces = list;
        this.isInterface = bl2;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    @Override
    public BasicValue newValue(Type type) {
        BasicValue basicValue;
        boolean bl2;
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        boolean bl3 = bl2 = type.getSort() == 9;
        if (bl2) {
            switch (type.getElementType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new BasicValue(type);
                }
            }
        }
        if (BasicValue.REFERENCE_VALUE.equals(basicValue = super.newValue(type))) {
            if (bl2) {
                basicValue = this.newValue(type.getElementType());
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < type.getDimensions(); ++i2) {
                    stringBuilder.append('[');
                }
                stringBuilder.append(basicValue.getType().getDescriptor());
                basicValue = new BasicValue(Type.getType(stringBuilder.toString()));
            } else {
                basicValue = new BasicValue(type);
            }
        }
        return basicValue;
    }

    @Override
    protected boolean isArrayValue(BasicValue basicValue) {
        Type type = basicValue.getType();
        return type != null && (type.getSort() == 9 || type.equals(NULL_TYPE));
    }

    @Override
    protected BasicValue getElementValue(BasicValue basicValue) throws AnalyzerException {
        Type type = basicValue.getType();
        if (type != null) {
            if (type.getSort() == 9) {
                return this.newValue(Type.getType(type.getDescriptor().substring(1)));
            }
            if (type.equals(NULL_TYPE)) {
                return basicValue;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected boolean isSubTypeOf(BasicValue basicValue, BasicValue basicValue2) {
        Type type = basicValue.getType();
        Type type2 = basicValue2.getType();
        if (type == null || type2 == null) {
            return type == null && type2 == null;
        }
        if (type.equals(type2)) {
            return true;
        }
        switch (type2.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 9: 
            case 10: {
                if (type.equals(NULL_TYPE)) {
                    return true;
                }
                int n2 = 0;
                if (type.getSort() == 9) {
                    n2 = type.getDimensions();
                    if ((type = type.getElementType()).getSort() != 10) {
                        --n2;
                        type = OBJECT_TYPE;
                    }
                }
                int n3 = 0;
                if (type2.getSort() == 9) {
                    n3 = type2.getDimensions();
                    if ((type2 = type2.getElementType()).getSort() != 10) {
                        return false;
                    }
                }
                if (n2 < n3) {
                    return false;
                }
                if (n2 > n3) {
                    type = OBJECT_TYPE;
                }
                if (this.isAssignableFrom(type2, type)) {
                    return true;
                }
                if (this.getClass(type2).isInterface()) {
                    return Object.class.isAssignableFrom(this.getClass(type));
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    @Override
    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        Type type = basicValue.getType();
        Type type2 = basicValue2.getType();
        if (type == null || type2 == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (type.equals(type2)) {
            return basicValue;
        }
        if (type.getSort() != 10 && type.getSort() != 9) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (type2.getSort() != 10 && type2.getSort() != 9) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (type.equals(NULL_TYPE)) {
            return basicValue2;
        }
        if (type2.equals(NULL_TYPE)) {
            return basicValue;
        }
        int n2 = 0;
        if (type.getSort() == 9) {
            n2 = type.getDimensions();
            if ((type = type.getElementType()).getSort() != 10) {
                --n2;
                type = OBJECT_TYPE;
            }
        }
        int n3 = 0;
        if (type2.getSort() == 9) {
            n3 = type2.getDimensions();
            if ((type2 = type2.getElementType()).getSort() != 10) {
                --n3;
                type2 = OBJECT_TYPE;
            }
        }
        if (n2 != n3) {
            return this.newArrayValue(OBJECT_TYPE, Math.min(n2, n3));
        }
        if (this.isAssignableFrom(type, type2)) {
            return this.newArrayValue(type, n2);
        }
        if (this.isAssignableFrom(type2, type)) {
            return this.newArrayValue(type2, n2);
        }
        if (!this.isInterface(type)) {
            while (!type.equals(OBJECT_TYPE)) {
                if (!this.isAssignableFrom(type = this.getSuperClass(type), type2)) continue;
                return this.newArrayValue(type, n2);
            }
        }
        return this.newArrayValue(OBJECT_TYPE, n2);
    }

    private BasicValue newArrayValue(Type type, int n2) {
        if (n2 == 0) {
            return this.newValue(type);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('[');
        }
        stringBuilder.append(type.getDescriptor());
        return this.newValue(Type.getType(stringBuilder.toString()));
    }

    protected boolean isInterface(Type type) {
        if (this.currentClass != null && this.currentClass.equals(type)) {
            return this.isInterface;
        }
        return this.getClass(type).isInterface();
    }

    protected Type getSuperClass(Type type) {
        if (this.currentClass != null && this.currentClass.equals(type)) {
            return this.currentSuperClass;
        }
        Class<?> clazz = this.getClass(type).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    protected boolean isAssignableFrom(Type type, Type type2) {
        if (type.equals(type2)) {
            return true;
        }
        if (this.currentClass != null && this.currentClass.equals(type)) {
            Type type3 = this.getSuperClass(type2);
            if (type3 == null) {
                return false;
            }
            if (this.isInterface) {
                return type2.getSort() == 10 || type2.getSort() == 9;
            }
            return this.isAssignableFrom(type, type3);
        }
        if (this.currentClass != null && this.currentClass.equals(type2)) {
            if (this.isAssignableFrom(type, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (Type type4 : this.currentClassInterfaces) {
                    if (!this.isAssignableFrom(type, type4)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.getClass(type).isAssignableFrom(this.getClass(type2));
    }

    protected Class<?> getClass(Type type) {
        try {
            if (type.getSort() == 9) {
                return Class.forName(type.getDescriptor().replace('/', '.'), false, this.loader);
            }
            return Class.forName(type.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(classNotFoundException.toString(), classNotFoundException);
        }
    }
}

