/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public final class Memoizer<R>
implements Supplier<R> {
    @HeapUsage.Deep
    private volatile Supplier<? extends R> supplier;
    @HeapUsage.Deep
    private R value;

    private Memoizer(Supplier<? extends R> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public static <R> Memoizer<R> memoize(Supplier<R> supplier) {
        return new Memoizer<R>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get() {
        if (this.supplier != null) {
            Memoizer memoizer = this;
            synchronized (memoizer) {
                if (this.supplier != null) {
                    this.value = this.supplier.get();
                    this.supplier = null;
                }
            }
        }
        return this.value;
    }

    public void ifPresent(Consumer<R> consumer) {
        if (this.value == null) {
            return;
        }
        consumer.accept(this.value);
    }
}

