/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Protocol {
    HTTP("http"),
    HTTPS("https"),
    TCP("tcp");

    public static final Protocol FALLBACK_VALUE;
    private String value;
    private static final Pattern PROTOCOL_REGEX;

    public static Protocol fromString(String string) {
        if (string == null) {
            return FALLBACK_VALUE;
        }
        Matcher matcher = PROTOCOL_REGEX.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            if ("http".equalsIgnoreCase(string2)) {
                return HTTP;
            }
            if ("https".equalsIgnoreCase(string2)) {
                return HTTPS;
            }
        }
        return FALLBACK_VALUE;
    }

    private Protocol(String string2) {
        this.value = string2;
    }

    private Protocol() {
    }

    String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    static {
        FALLBACK_VALUE = HTTP;
        PROTOCOL_REGEX = Pattern.compile("(HTTPS?)(/\\d.\\d)?", 2);
    }
}

