/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.settings.protect;

import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import java.util.Objects;

public enum ProtectionModeDTM {
    OFF,
    MONITORING,
    BLOCKING;


    public static ProtectionModeDTM fromString(String string) {
        Objects.requireNonNull(string);
        string = string.toUpperCase();
        if ("MONITOR".equals(string)) {
            return MONITORING;
        }
        if ("BLOCK".equals(string) || "BLOCK_AT_PERIMETER".equals(string)) {
            return BLOCKING;
        }
        return ProtectionModeDTM.valueOf(string);
    }

    public CommonConfigProtectionMode toCommonConfig() {
        switch (this) {
            case OFF: {
                return CommonConfigProtectionMode.OFF;
            }
            case MONITORING: {
                return CommonConfigProtectionMode.MONITOR;
            }
            case BLOCKING: {
                return CommonConfigProtectionMode.BLOCK;
            }
        }
        throw new IllegalArgumentException("Invalid ProtectionModeDTM value: " + (Object)((Object)this));
    }
}

