/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@DontObfuscate
public final class ApplicationArchitecture {
    private final Map<ArchitectureComponent, Long> components = new HashMap<ArchitectureComponent, Long>();
    @o
    static int MAX_SIZE_COMPONENTS = 500;
    @o
    static long TTL_COMPONENTS_MS = 3600000L;

    public static ApplicationArchitecture create() {
        return new ApplicationArchitecture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addComponent(ArchitectureComponent architectureComponent, long l2) {
        if (architectureComponent == null || this.components.size() >= MAX_SIZE_COMPONENTS) {
            return false;
        }
        Long l3 = this.components.get(architectureComponent);
        if (l3 != null && l3 > l2) {
            return false;
        }
        Map<ArchitectureComponent, Long> map = this.components;
        synchronized (map) {
            if (this.components.size() < MAX_SIZE_COMPONENTS) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var5_4
                Long l4 = this.components.putIfAbsent(architectureComponent, 0L);
                return l4 == null || l4 <= l2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @o
    public Collection<ArchitectureComponentDTM> getComponentDTMsForTesting() {
        Map<ArchitectureComponent, Long> map = this.components;
        synchronized (map) {
            return this.components.keySet().stream().map(ArchitectureComponent::toDTM).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @o
    public Map<ArchitectureComponent, Long> getComponentsForTesting() {
        Map<ArchitectureComponent, Long> map = this.components;
        synchronized (map) {
            return Collections.unmodifiableMap(new HashMap<ArchitectureComponent, Long>(this.components));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @o
    public Collection<ArchitectureComponentDTM> prepareComponentsForReporting(long l2) {
        long l3 = l2 + TTL_COMPONENTS_MS;
        Map<ArchitectureComponent, Long> map = this.components;
        synchronized (map) {
            ArrayList<ArchitectureComponent> arrayList = null;
            for (Map.Entry<ArchitectureComponent, Long> entry : this.components.entrySet()) {
                if (entry.getValue() > l2) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<ArchitectureComponent>();
                }
                arrayList.add((ArchitectureComponent)entry.getKey());
                entry.setValue(l3);
            }
            if (arrayList == null) {
                return Collections.emptyList();
            }
            ArrayList arrayList2 = new ArrayList(this.components.size());
            for (ArchitectureComponent architectureComponent : arrayList) {
                arrayList2.add(architectureComponent.toDTM());
            }
            return arrayList2;
        }
    }

    private ApplicationArchitecture() {
    }
}

