/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.spring;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.a.a;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.thirdparty.ccsso.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.context.propagation.TextMapPropagator;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.Collection;

@DontObfuscate
@m
public class ContrastObserveSpringDispatcherImpl
implements ContrastObserveSpringDispatcher {
    private final Config config;
    private static final String ROLE_PREFIX = "ROLE_";
    private static final Logger logger = LoggerFactory.getLogger(ContrastObserveSpringDispatcherImpl.class);

    ContrastObserveSpringDispatcherImpl(Config config) {
        this.config = config;
    }

    public void onExecute(Object object2, Object object3) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object2;
        if (contrastContext.http().getRequest() == null) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        TextMapPropagator textMapPropagator = application.otel().a().getTextMapPropagator();
        textMapPropagator.inject(contrastContext.observe().storeInContext(Context.root()), object3, (object, string, string2) -> Reflect.reflect(object, logger).invoke("getHeaders").invoke("add", string, string2));
    }

    public void onAuthorizationCheck(Object object, String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        httpRequest.context().putIfAbsent(RootSpan.AUTHZ_CONTEXT_KEY, a.a().a(string).b("authz-request").a(application).a());
    }

    public void onRouteAuthorization(Object object, Collection<String> collection, String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null || contrastContext.application().current() == null) {
            return;
        }
        a.a a2 = a.a().a(string).b("authz-request").a(contrastContext.application().current());
        if (collection != null && !collection.isEmpty()) {
            a2.a(collection);
        }
        httpRequest.context().put(RootSpan.AUTHZ_CONTEXT_KEY, a2.a());
    }

    public void onHasAnyAuthorityName(Object object, String string, String[] stringArray, String string2) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        Span span = rootSpan.startChildSpan(contrastContext, "authz-request", string2);
        if (span == null) {
            return;
        }
        if (ROLE_PREFIX.equals(string) && stringArray != null && stringArray.length > 0) {
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "rbac");
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_RBAC_ROLE, String.join((CharSequence)", ", stringArray));
        }
        span.end();
        rootSpan.popContext();
        application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_REQUEST_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
    }

    public void onPermissionsCheck(Object object, Object object2, String string) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        RootSpan rootSpan = contrastContext.observe();
        if (rootSpan == null || !rootSpan.isRecording()) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        Span span = rootSpan.startChildSpan(contrastContext, "authz-request", string);
        if (span == null) {
            return;
        }
        if (object2 instanceof String) {
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "dac");
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_DAC_PERMISSION, (String)object2);
        }
        span.end();
        rootSpan.popContext();
        application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_REQUEST_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.current()));
    }

    public void onExchangeFilter(Object object2, Object object3) {
        if (!this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object2;
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        application.otel().a().getTextMapPropagator().inject(Context.current(), object3, (object, string, string2) -> {
            if (object != null) {
                Reflect.reflect(object, logger).invoke("header", string, new String[]{string2});
            }
        });
    }
}

