/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.xss;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.generated.tags.Tag;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.e;
import com.contrastsecurity.agent.plugins.security.controller.trigger.f;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicyManager;
import com.contrastsecurity.agent.plugins.security.policy.i;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Parameter;
import com.contrastsecurity.agent.plugins.security.policy.rules.ParameterList;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.a;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.reflection.ReflectionUtil;
import com.contrastsecurity.agent.stack.StackCapture;
import com.contrastsecurity.agent.stack.i;
import com.contrastsecurity.agent.stack.l;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

@DontObfuscate
@m
final class ContrastFreemarkerDispatcherImpl
implements ContrastFreemarkerDispatcher {
    private final TraceController traceController;
    private final c codeEventFactory;
    private final f triggerHandler;
    private final com.contrastsecurity.agent.stack.i stackCaptureFactory;
    private final ContrastPolicyManager policyManager;
    private static Event RULE_EVENT;
    private static final String FAKE_TEMPLATENAME = "unknown.ftl";
    private static final String FAKE_SINK_CLASSNAME = "freemarker.core.Renderer";
    private static final String FAKE_SINK_FILENAME = "Renderer.java";
    private static final String FAKE_SINK_METHOD_NAME = "output";
    private static final String FAKE_TEMPLATE_METHOD_NAME = "print";
    private static final String FAKE_METHOD_DESC = "(Ljava/lang/String;)V";
    private static final MethodDescription CALLEE;
    private static final int FAKE_SINK_LINE = 10;
    private static final String RULE_NAME = "reflected-xss";
    private static final Logger logger;

    public ContrastFreemarkerDispatcherImpl(TraceController traceController, c c2, f f2, com.contrastsecurity.agent.stack.i i2, ContrastPolicyManager contrastPolicyManager) {
        this.traceController = traceController;
        this.codeEventFactory = Objects.requireNonNull(c2);
        this.triggerHandler = f2;
        this.stackCaptureFactory = i2;
        this.policyManager = contrastPolicyManager;
    }

    public void onVariableOutput(Object object, Object object2, Object object3, Object object4) {
        if (!(object2 instanceof String)) {
            return;
        }
        String string = (String)object2;
        if (string.isEmpty() || object3 == null || object4 == null) {
            return;
        }
        this._onVariableOutput((ContrastContext)object, string, object3, object4);
    }

    private void _onVariableOutput(ContrastContext contrastContext, String string, Object object, Object object2) {
        AssessmentContext assessmentContext = contrastContext.assessment();
        if (!this.traceController.isTracked(assessmentContext, string)) {
            return;
        }
        logger.debug("TraceDispatcher.isTracked returned true");
        Object object3 = this.getNonEscapingExpression(object);
        if (object3 != null) {
            logger.debug("Expression not null");
            this.reportXSS(contrastContext, string, object, object3, object2);
        }
    }

    private Object getNonEscapingExpression(Object object) {
        Object object2;
        Reflect reflect = Reflect.reflect(object, logger);
        Object object3 = reflect.field("escapedExpression").asNullable(Object.class);
        if (object3 == null) {
            return null;
        }
        Object object4 = reflect.reset(object).field("outputFormat").asNullable(Object.class);
        if (object4 != null && (((String)(object2 = object4.toString())).contains("HTMLOutputFormat") || ((String)object2).contains("XMLOutputFormat"))) {
            return null;
        }
        object2 = object3.getClass();
        String string = object3.toString();
        boolean bl2 = string.contains("?url") || string.contains("?xhtml") || string.contains("?html") || string.contains("?xml") || string.contains("?json_string") || ((Class)object2).getName().contains("Encoding");
        return bl2 ? null : object3;
    }

    private void reportXSS(ContrastContext contrastContext, String string, Object object, Object object2, Object object3) throws i {
        Trace trace = this.traceController.getTrace(contrastContext.assessment(), string);
        if (trace == null) {
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            return;
        }
        ContrastPolicy contrastPolicy = this.policyManager.currentPolicy();
        Rule rule = contrastPolicy.getRuleById(RULE_NAME);
        if (rule == null || !rule.isEnabled()) {
            return;
        }
        List<StackTraceElement> list = this.createStack(this.stackCaptureFactory.a(i.a.d), object, object3);
        StackCapture stackCapture = l.a(list);
        com.contrastsecurity.agent.plugins.security.model.l l2 = (com.contrastsecurity.agent.plugins.security.model.l)((com.contrastsecurity.agent.plugins.security.model.l)((com.contrastsecurity.agent.plugins.security.model.l)((com.contrastsecurity.agent.plugins.security.model.l)((com.contrastsecurity.agent.plugins.security.model.l)this.codeEventFactory.b(contrastContext.assessment()).a(CALLEE)).a(rule).c("P0")).a(new Object[]{string})).a(object)).a(stackCapture);
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent != null) {
            l2.d(codeEvent);
        }
        TriggerEvent triggerEvent = l2.g();
        e e2 = new e();
        e2.a(true);
        e2.a(trace);
        e2.a(stackCapture);
        a a2 = new a();
        a2.a(CALLEE);
        a2.a(triggerEvent);
        a2.a(e2);
        a2.a(this.makeEvent(rule, CALLEE));
        logger.debug("Tracing trigger");
        this.triggerHandler.traceTrigger(contrastContext, FAKE_TEMPLATE_METHOD_NAME, FAKE_METHOD_DESC, 1, object3, object3.getClass(), new Object[]{string}, null, RULE_NAME, (short)-1, a2);
    }

    private Event makeEvent(Rule rule, MethodDescription methodDescription) throws i {
        if (RULE_EVENT == null) {
            RULE_EVENT = new Event(rule, methodDescription.getSignature());
            RULE_EVENT.setExpressionType(null);
            RULE_EVENT.setObjectRequiresTracking(false);
            ParameterList parameterList = new ParameterList();
            parameterList.setMode(ParameterList.Mode.Or);
            parameterList.setParameters(new Parameter[]{this.makeFreemarkerParameter()});
            RULE_EVENT.setParameterList(parameterList);
        }
        return RULE_EVENT;
    }

    private Parameter makeFreemarkerParameter() {
        Parameter parameter = new Parameter(0, true);
        parameter.setDisallowedTags(EnumSet.of(Tag.HTTP_TOKEN_LIMITED_CHARS, new Tag[]{Tag.NUMERIC_LIMITED_CHARS, Tag.CUSTOM_VALIDATED, Tag.BASE64_ENCODED, Tag.CSS_ENCODED, Tag.FTL_ENCODED, Tag.HTML_ENCODED, Tag.JSON_ENCODED, Tag.JS_ENCODED, Tag.LDAP_ENCODED, Tag.OS_ENCODED, Tag.SQL_ENCODED, Tag.URL_ENCODED, Tag.VBSCRIPT_ENCODED, Tag.XML_ENCODED, Tag.XPATH_ENCODED, Tag.XSS_ENCODED}));
        return parameter;
    }

    private List<StackTraceElement> createStack(StackCapture stackCapture, Object object, Object object2) {
        int n2 = this.reflectLineNumber(object);
        String string = this.reflectTemplateName(object2);
        String string2 = this.generateTemplateClassName(string);
        List<Object> list = stackCapture == null ? Collections.emptyList() : stackCapture.traceWithoutLeadingContrastCode();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(list.size() + 2);
        arrayList.add(new StackTraceElement(FAKE_SINK_CLASSNAME, FAKE_SINK_METHOD_NAME, FAKE_SINK_FILENAME, 10));
        arrayList.add(new StackTraceElement(string2, FAKE_TEMPLATE_METHOD_NAME, string, n2));
        arrayList.addAll(list);
        return arrayList;
    }

    private String generateTemplateClassName(String string) {
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        return string.substring(n2 + 1);
    }

    private String reflectTemplateName(Object object) {
        String string = FAKE_TEMPLATENAME;
        try {
            Class<?> clazz = object.getClass();
            Method method = ReflectionUtil.getMethod(clazz, "getTemplate");
            Object object2 = method.invoke(object, Empty.OBJ_ARRAY);
            Method method2 = ReflectionUtil.getMethod(object2.getClass(), "getName");
            string = (String)method2.invoke(object2, Empty.OBJ_ARRAY);
            if (string == null) {
                string = FAKE_TEMPLATENAME;
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem reading template name", exception2);
        }
        return string;
    }

    private int reflectLineNumber(Object object) {
        Class<?> clazz = object.getClass();
        int n2 = -1;
        try {
            while ((clazz = clazz.getSuperclass()) != null) {
                if (!clazz.getSimpleName().equals("TemplateObject")) continue;
                Field field = ReflectionUtil.getDeclaredField(clazz, "beginLine");
                n2 = (Integer)field.get(object);
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem generating line number", exception2);
        }
        return n2;
    }

    static {
        CALLEE = new MethodDescription(FAKE_SINK_CLASSNAME, FAKE_TEMPLATE_METHOD_NAME, FAKE_METHOD_DESC, 0);
        logger = LoggerFactory.getLogger(ContrastFreemarkerDispatcherImpl.class);
    }
}

