/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.scope;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.scope.ScopeType;
import com.contrastsecurity.agent.scope.Scoping;

@DontObfuscate
public class ScopeAssess {
    private static boolean enabled;

    private ScopeAssess() {
    }

    public static boolean inScope(Scoping scoping) {
        return !enabled || scoping.inScope(ScopeType.ASSESS);
    }

    public static boolean inAssessOrSamplingScope(Scoping scoping) {
        if (!enabled) {
            return true;
        }
        return scoping.inScope(ScopeType.ASSESS) || scoping.inScope(ScopeType.ASSESS_SAMPLING);
    }

    public static boolean isTaggingDisallowed(Scoping scoping, boolean bl2) {
        if (!enabled) {
            return true;
        }
        if (scoping.inScope(ScopeType.ASSESS_SAMPLING)) {
            return true;
        }
        if (!scoping.inOutermostScope(ScopeType.ASSESS)) {
            return true;
        }
        return !bl2 && scoping.inScope(ScopeType.ASSESS_PROPAGATION);
    }

    public static boolean isCloneAllowed(Scoping scoping) {
        return scoping.isUnscoped(ScopeType.ASSESS) && scoping.isUnscoped(ScopeType.ASSESS_SAMPLING);
    }

    public static boolean isScopedPropagationAllowed(Scoping scoping) {
        if (!enabled) {
            return false;
        }
        return scoping.isUnscoped(ScopeType.ASSESS) && scoping.isUnscoped(ScopeType.ASSESS_SAMPLING) && scoping.inOutermostScope(ScopeType.ASSESS_PROPAGATION);
    }

    public static boolean isSourceCreationDisallowed(Scoping scoping) {
        return scoping.inScope(ScopeType.ASSESS) || scoping.inScope(ScopeType.ASSESS_SAMPLING) || !scoping.inOutermostScope(ScopeType.ASSESS_SOURCE);
    }

    public static boolean isUnscopedPropagationAllowed(Scoping scoping) {
        if (!enabled) {
            return true;
        }
        return scoping.isUnscoped(ScopeType.ASSESS) && scoping.isUnscoped(ScopeType.ASSESS_SAMPLING);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean bl2) {
        enabled = bl2;
    }
}

