/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.telemetry.c;
import com.contrastsecurity.agent.util.F;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.time.DurationFormatUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

@DontObfuscate
public class PerfUtil {
    private static final boolean PROFILING_STARTUP = H.b(l.b(ConfigProperty.PROFILE_STARTUP.legacySystemPropertyName()));
    private static final String PREMAIN_DURATION_HEADER = "Premain Duration";
    private static final String REQUEST_COMPLETE_HEADER = "Uptime to First Request Complete";
    private static final String REQUEST_DURATION_HEADER = "First Request Duration";
    @o
    static final String STARTUP_STATS_HEADER_ROW = "Premain Duration (ms),Uptime to First Request Complete (ms),First Request Duration (ms)";
    @o
    static final String STARTUP_STATS_FILE_NAME = "startup-stats.csv";
    private static final Logger logger = LoggerFactory.getLogger(PerfUtil.class);

    private static boolean notProfilingStartup() {
        return !PROFILING_STARTUP && !logger.isDebugEnabled();
    }

    public static void printStartupTimingMessage(a a2, String string, F f2) {
        if (PerfUtil.notProfilingStartup()) {
            return;
        }
        String string2 = PerfUtil.createMessage(a2, string, f2.toString());
        PerfUtil.printStartupTimingMessage(string2);
    }

    public static void printStartupTimingMessage(a a2, String string, long l2) {
        if (PerfUtil.notProfilingStartup()) {
            return;
        }
        String string2 = PerfUtil.createMessage(a2, string, DurationFormatUtils.formatDurationHMS(l2));
        PerfUtil.printStartupTimingMessage(string2);
    }

    public static void printStartupTimingMessage(String string) {
        logger.debug(string);
        if (PROFILING_STARTUP) {
            PreConfigUtil.out(string);
        }
    }

    private static String createMessage(a a2, String string, String string2) {
        return "[startup] " + StringUtils.repeat("\t", a2.ordinal()) + string + " " + string2;
    }

    public static f newStartupReportingFirstRequestEndListener(StartupTiming startupTiming, c c2, WorkingDirectories workingDirectories) {
        return PerfUtil.newStartupReportingFirstRequestEndListener(PROFILING_STARTUP, startupTiming, c2, workingDirectories);
    }

    @o
    static f newStartupReportingFirstRequestEndListener(boolean bl2, StartupTiming startupTiming, c c2, WorkingDirectories workingDirectories) {
        return l2 -> {
            PerfUtil.writeStartupStats(bl2, startupTiming, l2, workingDirectories);
            c2.a("uptime-first-request-complete", startupTiming.currentJvmUptimeMs());
            c2.a("first-request-duration", l2);
        };
    }

    @o
    static void writeStartupStats(boolean bl2, StartupTiming startupTiming, long l2, WorkingDirectories workingDirectories) {
        long l3 = startupTiming.currentJvmUptimeMs();
        PerfUtil.printStartupTimingMessage(a.f, PREMAIN_DURATION_HEADER, startupTiming.premainElapsedTimeMs());
        PerfUtil.printStartupTimingMessage(a.f, REQUEST_COMPLETE_HEADER, l3);
        PerfUtil.printStartupTimingMessage(a.f, REQUEST_DURATION_HEADER, l2);
        if (!bl2) {
            return;
        }
        File file = new File(workingDirectories.workingDirectory(), STARTUP_STATS_FILE_NAME);
        try {
            PrintWriter printWriter = new PrintWriter(file, "UTF-8");
            try {
                printWriter.append(STARTUP_STATS_HEADER_ROW).append("\n").append(Long.toString(startupTiming.premainElapsedTimeMs())).append(",").append(Long.toString(l3)).append(",").append(Long.toString(l2)).append("\n");
                printWriter.close();
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                try {
                    printWriter.close();
                }
                catch (Throwable throwable3) {
                    Throwables.throwIfCritical(throwable3);
                    Throwable throwable4 = throwable3;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            PreConfigUtil.err("Failed to write startup stats to " + file + ".");
            iOException.printStackTrace(System.err);
        }
    }

    public static enum a {
        a(true, null),
        b(true, "sub"),
        c(false, "subs"),
        d(false, "subss"),
        e(false, "subsss"),
        f(true, null);

        private final boolean g;
        private final String h;

        private a(boolean bl2, String string2) {
            this.g = bl2;
            this.h = string2;
        }

        public boolean a() {
            return this.g;
        }

        public String b() {
            return this.h;
        }
    }
}

