/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import com.contrastsecurity.thirdparty.cggl.protobuf.AbstractProtobufList;
import com.contrastsecurity.thirdparty.cggl.protobuf.Internal;
import com.contrastsecurity.thirdparty.cggl.protobuf.PrimitiveNonBoxingCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class LongArrayList
extends AbstractProtobufList<Long>
implements Internal.LongList,
PrimitiveNonBoxingCollection,
RandomAccess {
    private static final LongArrayList EMPTY_LIST = new LongArrayList(new long[0], 0);
    private long[] array;
    private int size;

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    LongArrayList() {
        this(new long[10], 0);
    }

    private LongArrayList(long[] lArray, int n2) {
        this.array = lArray;
        this.size = n2;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        this.ensureIsMutable();
        if (n3 < n2) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, n3, this.array, n2, this.size - n3);
        this.size -= n3 - n2;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongArrayList)) {
            return super.equals(object);
        }
        LongArrayList longArrayList = (LongArrayList)object;
        if (this.size != longArrayList.size) {
            return false;
        }
        long[] lArray = longArrayList.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == lArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = 31 * n2 + Internal.hashLong(this.array[i2]);
        }
        return n2;
    }

    @Override
    public Internal.LongList mutableCopyWithCapacity(int n2) {
        if (n2 < this.size) {
            throw new IllegalArgumentException();
        }
        return new LongArrayList(Arrays.copyOf(this.array, n2), this.size);
    }

    @Override
    public Long get(int n2) {
        return this.getLong(n2);
    }

    @Override
    public long getLong(int n2) {
        this.ensureIndexInRange(n2);
        return this.array[n2];
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l2 = (Long)object;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.array[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Long set(int n2, Long l2) {
        return this.setLong(n2, l2);
    }

    @Override
    public long setLong(int n2, long l2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        long l3 = this.array[n2];
        this.array[n2] = l2;
        return l3;
    }

    @Override
    public boolean add(Long l2) {
        this.addLong(l2);
        return true;
    }

    @Override
    public void add(int n2, Long l2) {
        this.addLong(n2, l2);
    }

    @Override
    public void addLong(long l2) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int n2 = this.size * 3 / 2 + 1;
            long[] lArray = new long[n2];
            System.arraycopy(this.array, 0, lArray, 0, this.size);
            this.array = lArray;
        }
        this.array[this.size++] = l2;
    }

    private void addLong(int n2, long l2) {
        this.ensureIsMutable();
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        } else {
            int n3 = this.size * 3 / 2 + 1;
            long[] lArray = new long[n3];
            System.arraycopy(this.array, 0, lArray, 0, n2);
            System.arraycopy(this.array, n2, lArray, n2 + 1, this.size - n2);
            this.array = lArray;
        }
        this.array[n2] = l2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof LongArrayList)) {
            return super.addAll(collection);
        }
        LongArrayList longArrayList = (LongArrayList)collection;
        if (longArrayList.size == 0) {
            return false;
        }
        int n2 = Integer.MAX_VALUE - this.size;
        if (n2 < longArrayList.size) {
            throw new OutOfMemoryError();
        }
        int n3 = this.size + longArrayList.size;
        if (n3 > this.array.length) {
            this.array = Arrays.copyOf(this.array, n3);
        }
        System.arraycopy(longArrayList.array, 0, this.array, this.size, longArrayList.size);
        this.size = n3;
        ++this.modCount;
        return true;
    }

    @Override
    public Long remove(int n2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(n2);
        long l2 = this.array[n2];
        if (n2 < this.size - 1) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.size - n2 - 1);
        }
        --this.size;
        ++this.modCount;
        return l2;
    }

    private void ensureIndexInRange(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(n2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int n2) {
        return "Index:" + n2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

