/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface RecoveryDelayHandler {
    public long getDelay(int var1);

    public static class ExponentialBackoffDelayHandler
    implements RecoveryDelayHandler {
        private final List<Long> sequence;

        public ExponentialBackoffDelayHandler() {
            this.sequence = Arrays.asList(2000L, 3000L, 5000L, 8000L, 13000L, 21000L, 34000L);
        }

        public ExponentialBackoffDelayHandler(List<Long> list) {
            if (list == null || list.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.sequence = Collections.unmodifiableList(list);
        }

        @Override
        public long getDelay(int n2) {
            int n3 = n2 >= this.sequence.size() ? this.sequence.size() - 1 : n2;
            return this.sequence.get(n3);
        }
    }

    public static class DefaultRecoveryDelayHandler
    implements RecoveryDelayHandler {
        private final long networkRecoveryInterval;

        public DefaultRecoveryDelayHandler(long l2) {
            this.networkRecoveryInterval = l2;
        }

        @Override
        public long getDelay(int n2) {
            return this.networkRecoveryInterval;
        }
    }
}

