/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.thirdparty.crmq.client.LongString;
import com.contrastsecurity.thirdparty.crmq.client.MalformedFrameException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Frame {
    public final int type;
    public final int channel;
    private final byte[] payload;
    private final ByteArrayOutputStream accumulator;
    private static final int NON_BODY_SIZE = 8;

    public Frame(int n2, int n3) {
        this.type = n2;
        this.channel = n3;
        this.payload = null;
        this.accumulator = new ByteArrayOutputStream();
    }

    public Frame(int n2, int n3, byte[] byArray) {
        this.type = n2;
        this.channel = n3;
        this.payload = byArray;
        this.accumulator = null;
    }

    public static Frame fromBodyFragment(int n2, byte[] byArray, int n3, int n4) throws IOException {
        Frame frame = new Frame(3, n2);
        DataOutputStream dataOutputStream = frame.getOutputStream();
        dataOutputStream.write(byArray, n3, n4);
        return frame;
    }

    public static Frame readFrom(DataInputStream dataInputStream) throws IOException {
        int n2;
        try {
            n2 = dataInputStream.readUnsignedByte();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return null;
        }
        if (n2 == 65) {
            Frame.protocolVersionMismatch(dataInputStream);
        }
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readInt();
        byte[] byArray = new byte[n4];
        dataInputStream.readFully(byArray);
        int n5 = dataInputStream.readUnsignedByte();
        if (n5 != 206) {
            throw new MalformedFrameException("Bad frame end marker: " + n5);
        }
        return new Frame(n2, n3, byArray);
    }

    public static void protocolVersionMismatch(DataInputStream dataInputStream) throws IOException {
        MalformedFrameException malformedFrameException;
        int n2;
        byte[] byArray;
        byte[] objectArray = byArray = new byte[]{77, 81, 80};
        int string = objectArray.length;
        for (n2 = 0; n2 < string; ++n2) {
            byte by = objectArray[n2];
            int n3 = dataInputStream.readUnsignedByte();
            if (n3 == by) continue;
            throw new MalformedFrameException("Invalid AMQP protocol header from server: expected character " + by + ", got " + n3);
        }
        try {
            int[] iOException = new int[4];
            for (string = 0; string < 4; ++string) {
                iOException[string] = dataInputStream.readUnsignedByte();
            }
            if (iOException[0] == 1 && iOException[1] == 1 && iOException[2] == 8 && iOException[3] == 0) {
                malformedFrameException = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server is 0-8");
            } else {
                String string2 = "";
                for (n2 = 0; n2 < 4; ++n2) {
                    if (n2 != 0) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + iOException[n2];
                }
                malformedFrameException = new MalformedFrameException("AMQP protocol version mismatch; we are version 0-9-1, server sent signature " + string2);
            }
        }
        catch (IOException iOException) {
            malformedFrameException = new MalformedFrameException("Invalid AMQP protocol header from server");
        }
        throw malformedFrameException;
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.channel);
        if (this.accumulator != null) {
            dataOutputStream.writeInt(this.accumulator.size());
            this.accumulator.writeTo(dataOutputStream);
        } else {
            dataOutputStream.writeInt(this.payload.length);
            dataOutputStream.write(this.payload);
        }
        dataOutputStream.write(206);
    }

    public int size() {
        if (this.accumulator != null) {
            return this.accumulator.size() + 8;
        }
        return this.payload.length + 8;
    }

    public byte[] getPayload() {
        if (this.payload != null) {
            return this.payload;
        }
        return this.accumulator.toByteArray();
    }

    public DataInputStream getInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.getPayload()));
    }

    public DataOutputStream getOutputStream() {
        return new DataOutputStream(this.accumulator);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Frame(type=").append(this.type).append(", channel=").append(this.channel).append(", ");
        if (this.accumulator == null) {
            stringBuilder.append(this.payload.length).append(" bytes of payload)");
        } else {
            stringBuilder.append(this.accumulator.size()).append(" bytes of accumulator)");
        }
        return stringBuilder.toString();
    }

    public static long tableSize(Map<String, Object> map) throws UnsupportedEncodingException {
        long l2 = 0L;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            l2 += (long)Frame.shortStrSize(entry.getKey());
            l2 += Frame.fieldValueSize(entry.getValue());
        }
        return l2;
    }

    private static long fieldValueSize(Object object) throws UnsupportedEncodingException {
        long l2 = 1L;
        if (object instanceof String) {
            l2 += (long)Frame.longStrSize((String)object);
        } else if (object instanceof LongString) {
            l2 += 4L + ((LongString)object).length();
        } else if (object instanceof Integer) {
            l2 += 4L;
        } else if (object instanceof BigDecimal) {
            l2 += 5L;
        } else if (object instanceof Date || object instanceof Timestamp) {
            l2 += 8L;
        } else if (object instanceof Map) {
            Map map = (Map)object;
            l2 += 4L + Frame.tableSize(map);
        } else if (object instanceof Byte) {
            ++l2;
        } else if (object instanceof Double) {
            l2 += 8L;
        } else if (object instanceof Float) {
            l2 += 4L;
        } else if (object instanceof Long) {
            l2 += 8L;
        } else if (object instanceof Short) {
            l2 += 2L;
        } else if (object instanceof Boolean) {
            ++l2;
        } else if (object instanceof byte[]) {
            l2 += (long)(4 + ((byte[])object).length);
        } else if (object instanceof List) {
            l2 += 4L + Frame.arraySize((List)object);
        } else if (object instanceof Object[]) {
            l2 += 4L + Frame.arraySize((Object[])object);
        } else if (object != null) {
            throw new IllegalArgumentException("invalid value in table");
        }
        return l2;
    }

    public static long arraySize(List<?> list) throws UnsupportedEncodingException {
        long l2 = 0L;
        for (Object obj : list) {
            l2 += Frame.fieldValueSize(obj);
        }
        return l2;
    }

    public static long arraySize(Object[] objectArray) throws UnsupportedEncodingException {
        long l2 = 0L;
        for (Object object : objectArray) {
            l2 += Frame.fieldValueSize(object);
        }
        return l2;
    }

    private static int longStrSize(String string) throws UnsupportedEncodingException {
        return string.getBytes("utf-8").length + 4;
    }

    private static int shortStrSize(String string) throws UnsupportedEncodingException {
        return string.getBytes("utf-8").length + 1;
    }
}

