/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl;

import com.contrastsecurity.thirdparty.crmq.client.LongString;
import com.contrastsecurity.thirdparty.crmq.client.impl.ValueReader;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class MethodArgumentReader {
    private final ValueReader in;
    private int bits;
    private int nextBitMask;

    private void clearBits() {
        this.bits = 0;
        this.nextBitMask = 256;
    }

    public MethodArgumentReader(ValueReader valueReader) {
        this.in = valueReader;
        this.clearBits();
    }

    public final String readShortstr() throws IOException {
        this.clearBits();
        return this.in.readShortstr();
    }

    public final LongString readLongstr() throws IOException {
        this.clearBits();
        return this.in.readLongstr();
    }

    public final int readShort() throws IOException {
        this.clearBits();
        return this.in.readShort();
    }

    public final int readLong() throws IOException {
        this.clearBits();
        return this.in.readLong();
    }

    public final long readLonglong() throws IOException {
        this.clearBits();
        return this.in.readLonglong();
    }

    public final boolean readBit() throws IOException {
        if (this.nextBitMask > 128) {
            this.bits = this.in.readOctet();
            this.nextBitMask = 1;
        }
        boolean bl2 = (this.bits & this.nextBitMask) != 0;
        this.nextBitMask <<= 1;
        return bl2;
    }

    public final Map<String, Object> readTable() throws IOException {
        this.clearBits();
        return this.in.readTable();
    }

    public final int readOctet() throws IOException {
        this.clearBits();
        return this.in.readOctet();
    }

    public final Date readTimestamp() throws IOException {
        this.clearBits();
        return this.in.readTimestamp();
    }
}

