/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client.impl.nio;

import com.contrastsecurity.thirdparty.crmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.crmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.ByteBufferOutputStream;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.FrameBuilder;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.FrameWriteRequest;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.HeaderWriteRequest;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioContext;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioHelper;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioLoopContext;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioParams;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.NioQueue;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.SelectorHolder;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.SslEngineByteBufferOutputStream;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.SslEngineFrameBuilder;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.SslEngineHelper;
import com.contrastsecurity.thirdparty.crmq.client.impl.nio.WriteRequest;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

public class SocketChannelFrameHandlerState {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketChannelFrameHandlerState.class);
    private static final int SOCKET_CLOSING_TIMEOUT = 1;
    private final SocketChannel channel;
    private final NioQueue writeQueue;
    private volatile AMQConnection connection;
    private long lastActivity;
    private final SelectorHolder writeSelectorState;
    private final SelectorHolder readSelectorState;
    final boolean ssl;
    final SSLEngine sslEngine;
    final ByteBuffer plainOut;
    final ByteBuffer plainIn;
    final ByteBuffer cipherOut;
    final ByteBuffer cipherIn;
    final DataOutputStream outputStream;
    final FrameBuilder frameBuilder;

    public SocketChannelFrameHandlerState(SocketChannel socketChannel, NioLoopContext nioLoopContext, NioParams nioParams, SSLEngine sSLEngine) {
        this.channel = socketChannel;
        this.readSelectorState = nioLoopContext.readSelectorState;
        this.writeSelectorState = nioLoopContext.writeSelectorState;
        NioContext nioContext = new NioContext(nioParams, sSLEngine);
        this.writeQueue = nioParams.getWriteQueueFactory() == null ? NioParams.DEFAULT_WRITE_QUEUE_FACTORY.create(nioContext) : nioParams.getWriteQueueFactory().create(nioContext);
        this.sslEngine = sSLEngine;
        if (this.sslEngine == null) {
            this.ssl = false;
            this.plainOut = nioLoopContext.writeBuffer;
            this.cipherOut = null;
            this.plainIn = nioLoopContext.readBuffer;
            this.cipherIn = null;
            this.outputStream = new DataOutputStream(new ByteBufferOutputStream(socketChannel, this.plainOut));
            this.frameBuilder = new FrameBuilder(socketChannel, this.plainIn);
        } else {
            this.ssl = true;
            this.plainOut = nioParams.getByteBufferFactory().createWriteBuffer(nioContext);
            this.cipherOut = nioParams.getByteBufferFactory().createEncryptedWriteBuffer(nioContext);
            this.plainIn = nioParams.getByteBufferFactory().createReadBuffer(nioContext);
            this.cipherIn = nioParams.getByteBufferFactory().createEncryptedReadBuffer(nioContext);
            this.outputStream = new DataOutputStream(new SslEngineByteBufferOutputStream(sSLEngine, this.plainOut, this.cipherOut, socketChannel));
            this.frameBuilder = new SslEngineFrameBuilder(sSLEngine, this.plainIn, this.cipherIn, socketChannel);
        }
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public NioQueue getWriteQueue() {
        return this.writeQueue;
    }

    public void sendHeader() throws IOException {
        this.sendWriteRequest(HeaderWriteRequest.SINGLETON);
    }

    public void write(Frame frame) throws IOException {
        this.sendWriteRequest(new FrameWriteRequest(frame));
    }

    private void sendWriteRequest(WriteRequest writeRequest) throws IOException {
        try {
            boolean bl2 = this.writeQueue.offer(writeRequest);
            if (!bl2) {
                throw new IOException("Frame enqueuing failed");
            }
            this.writeSelectorState.registerFrameHandlerState(this, 4);
            this.readSelectorState.selector.wakeup();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("Thread interrupted during enqueuing frame in write queue");
        }
    }

    public void startReading() {
        this.readSelectorState.registerFrameHandlerState(this, 1);
    }

    public AMQConnection getConnection() {
        return this.connection;
    }

    public void setConnection(AMQConnection aMQConnection) {
        this.connection = aMQConnection;
    }

    public void setLastActivity(long l2) {
        this.lastActivity = l2;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    void prepareForWriteSequence() {
        if (this.ssl) {
            this.plainOut.clear();
            this.cipherOut.clear();
        }
    }

    void endWriteSequence() {
        if (!this.ssl) {
            this.plainOut.clear();
        }
    }

    void prepareForReadSequence() throws IOException {
        if (this.ssl) {
            this.cipherIn.clear();
            this.plainIn.clear();
            this.cipherIn.flip();
            this.plainIn.flip();
        } else {
            NioHelper.read(this.channel, this.plainIn);
            this.plainIn.flip();
        }
    }

    boolean continueReading() throws IOException {
        if (this.ssl) {
            if (!this.plainIn.hasRemaining() && !this.cipherIn.hasRemaining()) {
                this.cipherIn.clear();
                int n2 = NioHelper.read(this.channel, this.cipherIn);
                if (n2 == 0) {
                    return false;
                }
                this.cipherIn.flip();
                return true;
            }
            return true;
        }
        if (!this.plainIn.hasRemaining()) {
            this.plainIn.clear();
            NioHelper.read(this.channel, this.plainIn);
            this.plainIn.flip();
        }
        return this.plainIn.hasRemaining();
    }

    void close() throws IOException {
        if (this.ssl) {
            SslEngineHelper.close(this.channel, this.sslEngine);
        }
        if (this.channel.isOpen()) {
            this.channel.socket().setSoLinger(true, 1);
            this.channel.close();
        }
    }
}

