/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dfs.internal;

import com.contrastsecurity.thirdparty.dfs.RateLimiterConfig;
import com.contrastsecurity.thirdparty.dfs.internal.RateLimiterStats;
import com.contrastsecurity.thirdparty.dfs.internal.util.Maths;
import java.time.Duration;

class SmoothRateLimiterStats
extends RateLimiterStats {
    final long intervalNanos;
    private long nextFreePermitNanos;

    SmoothRateLimiterStats(RateLimiterConfig<?> rateLimiterConfig, RateLimiterStats.Stopwatch stopwatch) {
        super(stopwatch);
        this.intervalNanos = rateLimiterConfig.getMaxRate().toNanos();
    }

    @Override
    public synchronized long acquirePermits(long l2, Duration duration) {
        long l3;
        long l4 = this.stopwatch.elapsedNanos();
        long l5 = l2 * this.intervalNanos;
        if (l4 >= this.nextFreePermitNanos) {
            long l6 = Maths.roundDown(l4, this.intervalNanos);
            l3 = Maths.add(l6, l5);
        } else {
            l3 = Maths.add(this.nextFreePermitNanos, l5);
        }
        long l7 = Math.max(l3 - l4 - this.intervalNanos, 0L);
        if (this.exceedsMaxWaitTime(l7, duration)) {
            return -1L;
        }
        this.nextFreePermitNanos = l3;
        return l7;
    }

    synchronized long getNextFreePermitNanos() {
        return this.nextFreePermitNanos;
    }

    @Override
    synchronized void reset() {
        this.stopwatch.reset();
        this.nextFreePermitNanos = 0L;
    }
}

