/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.aop;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.core.annotation.Counted;
import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Metrics;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@NonNullApi
public class CountedAspect {
    private static final Predicate<ProceedingJoinPoint> DONT_SKIP_ANYTHING = proceedingJoinPoint -> false;
    public final String DEFAULT_EXCEPTION_TAG_VALUE = "none";
    public final String RESULT_TAG_FAILURE_VALUE = "failure";
    public final String RESULT_TAG_SUCCESS_VALUE = "success";
    private static final String RESULT_TAG = "result";
    private static final String EXCEPTION_TAG = "exception";
    private final MeterRegistry registry;
    private final Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinPoint;
    private final Predicate<ProceedingJoinPoint> shouldSkip;

    public CountedAspect() {
        this(Metrics.globalRegistry);
    }

    public CountedAspect(MeterRegistry meterRegistry) {
        this(meterRegistry, DONT_SKIP_ANYTHING);
    }

    public CountedAspect(MeterRegistry meterRegistry, Function<ProceedingJoinPoint, Iterable<Tag>> function) {
        this(meterRegistry, function, DONT_SKIP_ANYTHING);
    }

    public CountedAspect(MeterRegistry meterRegistry, Predicate<ProceedingJoinPoint> predicate) {
        this(meterRegistry, proceedingJoinPoint -> Tags.of("class", proceedingJoinPoint.getStaticPart().getSignature().getDeclaringTypeName(), "method", proceedingJoinPoint.getStaticPart().getSignature().getName()), predicate);
    }

    public CountedAspect(MeterRegistry meterRegistry, Function<ProceedingJoinPoint, Iterable<Tag>> function, Predicate<ProceedingJoinPoint> predicate) {
        this.registry = meterRegistry;
        this.tagsBasedOnJoinPoint = function;
        this.shouldSkip = predicate;
    }

    @Around(value="@annotation(counted)", argNames="pjp,counted")
    public Object interceptAndRecord(ProceedingJoinPoint proceedingJoinPoint, Counted counted) throws Throwable {
        if (this.shouldSkip.test(proceedingJoinPoint)) {
            return proceedingJoinPoint.proceed();
        }
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        boolean bl2 = CompletionStage.class.isAssignableFrom(method.getReturnType());
        if (bl2) {
            try {
                return ((CompletionStage)proceedingJoinPoint.proceed()).whenComplete((object, throwable) -> this.recordCompletionResult(proceedingJoinPoint, counted, (Throwable)throwable));
            }
            catch (Throwable throwable2) {
                Throwables.throwIfCritical(throwable2);
                Throwable throwable3 = throwable2;
                this.record(proceedingJoinPoint, counted, throwable3.getClass().getSimpleName(), "failure");
                throw throwable3;
            }
        }
        try {
            Object object2 = proceedingJoinPoint.proceed();
            if (!counted.recordFailuresOnly()) {
                this.record(proceedingJoinPoint, counted, "none", "success");
            }
            return object2;
        }
        catch (Throwable throwable4) {
            Throwables.throwIfCritical(throwable4);
            Throwable throwable5 = throwable4;
            this.record(proceedingJoinPoint, counted, throwable5.getClass().getSimpleName(), "failure");
            throw throwable5;
        }
    }

    private void recordCompletionResult(ProceedingJoinPoint proceedingJoinPoint, Counted counted, Throwable throwable) {
        if (throwable != null) {
            String string = throwable.getCause() == null ? throwable.getClass().getSimpleName() : throwable.getCause().getClass().getSimpleName();
            this.record(proceedingJoinPoint, counted, string, "failure");
        } else if (!counted.recordFailuresOnly()) {
            this.record(proceedingJoinPoint, counted, "none", "success");
        }
    }

    private void record(ProceedingJoinPoint proceedingJoinPoint, Counted counted, String string, String string2) {
        this.counter(proceedingJoinPoint, counted).tag(EXCEPTION_TAG, string).tag(RESULT_TAG, string2).tags(counted.extraTags()).register(this.registry).increment();
    }

    private Counter.Builder counter(ProceedingJoinPoint proceedingJoinPoint, Counted counted) {
        Counter.Builder builder = Counter.builder(counted.value()).tags(this.tagsBasedOnJoinPoint.apply(proceedingJoinPoint));
        String string = counted.description();
        if (!string.isEmpty()) {
            builder.description(string);
        }
        return builder;
    }
}

