/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5;

import com.contrastsecurity.thirdparty.imm.common.KeyValues;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.http.Outcome;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.httpcomponents.hc5.HttpContextUtils;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.hc.core5.http.HttpResponse;
import java.io.IOException;

public class DefaultApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final DefaultApacheHttpClientObservationConvention INSTANCE = new DefaultApacheHttpClientObservationConvention();

    protected DefaultApacheHttpClientObservationConvention() {
    }

    @Override
    public String getName() {
        return "httpcomponents.httpclient.request";
    }

    @Override
    public String getContextualName(ApacheHttpClientContext apacheHttpClientContext) {
        return "HTTP " + this.getMethodString((HttpRequest)apacheHttpClientContext.getCarrier());
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext apacheHttpClientContext) {
        KeyValues keyValues = KeyValues.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue(this.getMethodString((HttpRequest)apacheHttpClientContext.getCarrier())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(apacheHttpClientContext.getUriMapper().apply((HttpRequest)apacheHttpClientContext.getCarrier())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS.withValue(this.getStatusValue((HttpResponse)apacheHttpClientContext.getResponse(), apacheHttpClientContext.getError())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME.withValue(this.getStatusOutcome((HttpResponse)apacheHttpClientContext.getResponse()).name()));
        if (apacheHttpClientContext.shouldExportTagsForRoute()) {
            keyValues = keyValues.and(HttpContextUtils.generateTagStringsForRoute(apacheHttpClientContext.getApacheHttpContext()));
        }
        return keyValues;
    }

    Outcome getStatusOutcome(@Nullable HttpResponse httpResponse) {
        return httpResponse != null ? Outcome.forStatus(httpResponse.getCode()) : Outcome.UNKNOWN;
    }

    String getStatusValue(@Nullable HttpResponse httpResponse, Throwable throwable) {
        if (throwable instanceof IOException || throwable instanceof HttpException || throwable instanceof RuntimeException) {
            return "IO_ERROR";
        }
        return httpResponse != null ? Integer.toString(httpResponse.getCode()) : "CLIENT_ERROR";
    }

    String getMethodString(@Nullable HttpRequest httpRequest) {
        return httpRequest != null && httpRequest.getMethod() != null ? httpRequest.getMethod() : "UNKNOWN";
    }
}

