/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server;

import com.contrastsecurity.thirdparty.imm.common.KeyValue;
import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.http.Outcome;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyObservationDocumentation;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyTags;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.RequestEvent;

class JerseyKeyValues {
    private static final KeyValue URI_NOT_FOUND = JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.URI.withValue("NOT_FOUND");
    private static final KeyValue URI_REDIRECTION = JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.URI.withValue("REDIRECTION");
    private static final KeyValue URI_ROOT = JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.URI.withValue("root");
    private static final KeyValue EXCEPTION_NONE = JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.EXCEPTION.withValue("None");
    private static final KeyValue STATUS_SERVER_ERROR = JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.STATUS.withValue("500");
    private static final KeyValue METHOD_UNKNOWN = JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.METHOD.withValue("UNKNOWN");

    private JerseyKeyValues() {
    }

    static KeyValue method(ContainerRequest containerRequest) {
        return containerRequest != null ? JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.METHOD.withValue(containerRequest.getMethod()) : METHOD_UNKNOWN;
    }

    static KeyValue status(ContainerResponse containerResponse) {
        return containerResponse != null ? JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.STATUS.withValue(Integer.toString(containerResponse.getStatus())) : STATUS_SERVER_ERROR;
    }

    static KeyValue uri(RequestEvent requestEvent) {
        String string;
        ContainerResponse containerResponse = requestEvent.getContainerResponse();
        if (containerResponse != null) {
            int n2 = containerResponse.getStatus();
            if (JerseyTags.isRedirection(n2) && requestEvent.getUriInfo().getMatchedResourceMethod() == null) {
                return URI_REDIRECTION;
            }
            if (n2 == 404 && requestEvent.getUriInfo().getMatchedResourceMethod() == null) {
                return URI_NOT_FOUND;
            }
        }
        if ((string = JerseyTags.getMatchingPattern(requestEvent)).equals("/")) {
            return URI_ROOT;
        }
        return JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.URI.withValue(string);
    }

    static KeyValue exception(RequestEvent requestEvent) {
        String string;
        int n2;
        Throwable throwable = requestEvent.getException();
        if (throwable == null) {
            return EXCEPTION_NONE;
        }
        ContainerResponse containerResponse = requestEvent.getContainerResponse();
        if (containerResponse != null && ((n2 = containerResponse.getStatus()) == 404 || JerseyTags.isRedirection(n2))) {
            return EXCEPTION_NONE;
        }
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.EXCEPTION.withValue(StringUtils.isNotEmpty(string = throwable.getClass().getSimpleName()) ? string : throwable.getClass().getName());
    }

    static KeyValue outcome(ContainerResponse containerResponse) {
        if (containerResponse != null) {
            Outcome outcome = Outcome.forStatus(containerResponse.getStatus());
            return JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.OUTCOME.withValue(outcome.name());
        }
        return JerseyObservationDocumentation.JerseyLegacyLowCardinalityTags.OUTCOME.withValue(Outcome.SERVER_ERROR.name());
    }
}

