/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty.DefaultJettyClientObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty.JettyClientContext;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty.JettyClientObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jetty.JettyClientTagsProvider;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.MeterFilter;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.OnlyOnceLoggingDenyMeterFilter;
import com.contrastsecurity.thirdparty.imm.core.instrument.observation.ObservationOrTimerCompatibleInstrumentation;
import com.contrastsecurity.thirdparty.imm.observation.ObservationRegistry;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;

@Incubating(since="1.5.0")
public class JettyClientMetrics
implements Request.Listener {
    static final String DEFAULT_JETTY_CLIENT_REQUESTS_TIMER_NAME = "jetty.client.requests";
    private final MeterRegistry registry;
    private final JettyClientTagsProvider tagsProvider;
    private final String timingMetricName;
    private final String contentSizeMetricName;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final JettyClientObservationConvention convention;
    private final BiFunction<Request, Result, String> uriPatternFunction;

    @Deprecated
    protected JettyClientMetrics(MeterRegistry meterRegistry, JettyClientTagsProvider jettyClientTagsProvider, String string, String string2, int n2) {
        this(meterRegistry, ObservationRegistry.NOOP, null, jettyClientTagsProvider, string, string2, n2, (request, result) -> jettyClientTagsProvider.uriPattern((Result)result));
    }

    private JettyClientMetrics(MeterRegistry meterRegistry, ObservationRegistry observationRegistry, @Nullable JettyClientObservationConvention jettyClientObservationConvention, JettyClientTagsProvider jettyClientTagsProvider, String string, String string2, int n2, BiFunction<Request, Result, String> biFunction) {
        this.registry = meterRegistry;
        this.tagsProvider = jettyClientTagsProvider;
        this.timingMetricName = string;
        this.contentSizeMetricName = string2;
        this.observationRegistry = observationRegistry;
        this.convention = jettyClientObservationConvention;
        this.uriPatternFunction = biFunction;
        OnlyOnceLoggingDenyMeterFilter onlyOnceLoggingDenyMeterFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", string));
        OnlyOnceLoggingDenyMeterFilter onlyOnceLoggingDenyMeterFilter2 = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number of URI tags for '%s'.", string2));
        meterRegistry.config().meterFilter(MeterFilter.maximumAllowableTags(this.timingMetricName, "uri", n2, onlyOnceLoggingDenyMeterFilter)).meterFilter(MeterFilter.maximumAllowableTags(this.contentSizeMetricName, "uri", n2, onlyOnceLoggingDenyMeterFilter2));
    }

    public void onQueued(Request request) {
        ObservationOrTimerCompatibleInstrumentation<JettyClientContext> observationOrTimerCompatibleInstrumentation = ObservationOrTimerCompatibleInstrumentation.start(this.registry, this.observationRegistry, () -> new JettyClientContext(request, this.uriPatternFunction), this.convention, DefaultJettyClientObservationConvention.INSTANCE);
        request.onComplete(result -> {
            observationOrTimerCompatibleInstrumentation.setResponse(result);
            long l2 = Optional.ofNullable(result.getRequest().getContent()).map(ContentProvider::getLength).orElse(0L);
            Iterable<Tag> iterable = this.tagsProvider.httpRequestTags(result);
            if (l2 >= 0L) {
                DistributionSummary.builder(this.contentSizeMetricName).description("Content sizes for Jetty HTTP client requests").tags(iterable).register(this.registry).record(l2);
            }
            observationOrTimerCompatibleInstrumentation.stop(this.timingMetricName, "Jetty HTTP client request timing", () -> iterable);
        });
    }

    @Deprecated
    public static Builder builder(MeterRegistry meterRegistry, JettyClientTagsProvider jettyClientTagsProvider) {
        return new Builder(meterRegistry, (request, result) -> jettyClientTagsProvider.uriPattern((Result)result));
    }

    public static Builder builder(MeterRegistry meterRegistry, BiFunction<Request, Result, String> biFunction) {
        return new Builder(meterRegistry, biFunction);
    }

    public static class Builder {
        private final MeterRegistry meterRegistry;
        private final BiFunction<Request, Result, String> uriPatternFunction;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private JettyClientTagsProvider tagsProvider;
        private String timingMetricName = "jetty.client.requests";
        private String contentSizeMetricName = "jetty.client.request.size";
        private int maxUriTags = 1000;
        @Nullable
        private JettyClientObservationConvention observationConvention;

        private Builder(MeterRegistry meterRegistry, BiFunction<Request, Result, String> biFunction) {
            this.meterRegistry = meterRegistry;
            this.uriPatternFunction = biFunction;
            this.tagsProvider = result -> (String)biFunction.apply(result.getRequest(), result);
        }

        public Builder timingMetricName(String string) {
            this.timingMetricName = string;
            return this;
        }

        public Builder contentSizeMetricName(String string) {
            this.contentSizeMetricName = string;
            return this;
        }

        public Builder maxUriTags(int n2) {
            this.maxUriTags = n2;
            return this;
        }

        public Builder tagsProvider(JettyClientTagsProvider jettyClientTagsProvider) {
            this.tagsProvider = jettyClientTagsProvider;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public Builder observationConvention(JettyClientObservationConvention jettyClientObservationConvention) {
            this.observationConvention = jettyClientObservationConvention;
            return this;
        }

        public JettyClientMetrics build() {
            return new JettyClientMetrics(this.meterRegistry, this.observationRegistry, this.observationConvention, this.tagsProvider, this.timingMetricName, this.contentSizeMetricName, this.maxUriTags, this.uriPatternFunction);
        }
    }
}

