/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jvm;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.TimedExecutor;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.TimedExecutorService;
import com.contrastsecurity.thirdparty.imm.core.instrument.internal.TimedScheduledExecutorService;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

@NonNullApi
@NonNullFields
public class ExecutorServiceMetrics
implements MeterBinder {
    private static boolean allowIllegalReflectiveAccess = true;
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ExecutorServiceMetrics.class);
    private static final String DEFAULT_EXECUTOR_METRIC_PREFIX = "";
    @Nullable
    private final ExecutorService executorService;
    private final Iterable<Tag> tags;
    private final String metricPrefix;

    public ExecutorServiceMetrics(@Nullable ExecutorService executorService, String string, Iterable<Tag> iterable) {
        this(executorService, string, DEFAULT_EXECUTOR_METRIC_PREFIX, iterable);
    }

    public ExecutorServiceMetrics(@Nullable ExecutorService executorService, String string, String string2, Iterable<Tag> iterable) {
        this.executorService = executorService;
        this.tags = Tags.concat(iterable, "name", string);
        this.metricPrefix = ExecutorServiceMetrics.sanitizePrefix(string2);
    }

    public static Executor monitor(MeterRegistry meterRegistry, Executor executor, String string, Iterable<Tag> iterable) {
        return ExecutorServiceMetrics.monitor(meterRegistry, executor, string, DEFAULT_EXECUTOR_METRIC_PREFIX, iterable);
    }

    public static Executor monitor(MeterRegistry meterRegistry, Executor executor, String string, String string2, Iterable<Tag> iterable) {
        if (executor instanceof ExecutorService) {
            return ExecutorServiceMetrics.monitor(meterRegistry, (ExecutorService)executor, string, string2, iterable);
        }
        return new TimedExecutor(meterRegistry, executor, string, ExecutorServiceMetrics.sanitizePrefix(string2), iterable);
    }

    public static Executor monitor(MeterRegistry meterRegistry, Executor executor, String string, Tag ... tagArray) {
        return ExecutorServiceMetrics.monitor(meterRegistry, executor, string, DEFAULT_EXECUTOR_METRIC_PREFIX, tagArray);
    }

    public static Executor monitor(MeterRegistry meterRegistry, Executor executor, String string, String string2, Tag ... tagArray) {
        return ExecutorServiceMetrics.monitor(meterRegistry, executor, string, string2, Arrays.asList(tagArray));
    }

    public static ExecutorService monitor(MeterRegistry meterRegistry, ExecutorService executorService, String string, Iterable<Tag> iterable) {
        return ExecutorServiceMetrics.monitor(meterRegistry, executorService, string, DEFAULT_EXECUTOR_METRIC_PREFIX, iterable);
    }

    public static ExecutorService monitor(MeterRegistry meterRegistry, ExecutorService executorService, String string, String string2, Iterable<Tag> iterable) {
        if (executorService instanceof ScheduledExecutorService) {
            return ExecutorServiceMetrics.monitor(meterRegistry, (ScheduledExecutorService)executorService, string, string2, iterable);
        }
        new ExecutorServiceMetrics(executorService, string, string2, iterable).bindTo(meterRegistry);
        return new TimedExecutorService(meterRegistry, executorService, string, ExecutorServiceMetrics.sanitizePrefix(string2), iterable);
    }

    public static ExecutorService monitor(MeterRegistry meterRegistry, ExecutorService executorService, String string, Tag ... tagArray) {
        return ExecutorServiceMetrics.monitor(meterRegistry, executorService, string, DEFAULT_EXECUTOR_METRIC_PREFIX, tagArray);
    }

    public static ExecutorService monitor(MeterRegistry meterRegistry, ExecutorService executorService, String string, String string2, Tag ... tagArray) {
        return ExecutorServiceMetrics.monitor(meterRegistry, executorService, string, string2, Arrays.asList(tagArray));
    }

    public static ScheduledExecutorService monitor(MeterRegistry meterRegistry, ScheduledExecutorService scheduledExecutorService, String string, Iterable<Tag> iterable) {
        return ExecutorServiceMetrics.monitor(meterRegistry, scheduledExecutorService, string, DEFAULT_EXECUTOR_METRIC_PREFIX, iterable);
    }

    public static ScheduledExecutorService monitor(MeterRegistry meterRegistry, ScheduledExecutorService scheduledExecutorService, String string, String string2, Iterable<Tag> iterable) {
        new ExecutorServiceMetrics(scheduledExecutorService, string, string2, iterable).bindTo(meterRegistry);
        return new TimedScheduledExecutorService(meterRegistry, scheduledExecutorService, string, ExecutorServiceMetrics.sanitizePrefix(string2), iterable);
    }

    public static ScheduledExecutorService monitor(MeterRegistry meterRegistry, ScheduledExecutorService scheduledExecutorService, String string, Tag ... tagArray) {
        return ExecutorServiceMetrics.monitor(meterRegistry, scheduledExecutorService, string, DEFAULT_EXECUTOR_METRIC_PREFIX, tagArray);
    }

    public static ScheduledExecutorService monitor(MeterRegistry meterRegistry, ScheduledExecutorService scheduledExecutorService, String string, String string2, Tag ... tagArray) {
        return ExecutorServiceMetrics.monitor(meterRegistry, scheduledExecutorService, string, string2, Arrays.asList(tagArray));
    }

    private static String sanitizePrefix(String string) {
        if (StringUtils.isBlank(string)) {
            return DEFAULT_EXECUTOR_METRIC_PREFIX;
        }
        if (!string.endsWith(".")) {
            return string + ".";
        }
        return string;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        if (this.executorService == null) {
            return;
        }
        String string = this.executorService.getClass().getName();
        if (this.executorService instanceof ThreadPoolExecutor) {
            this.monitor(meterRegistry, (ThreadPoolExecutor)this.executorService);
        } else if (this.executorService instanceof ForkJoinPool) {
            this.monitor(meterRegistry, (ForkJoinPool)this.executorService);
        } else if (allowIllegalReflectiveAccess) {
            if (string.equals("java.util.concurrent.Executors$DelegatedScheduledExecutorService")) {
                this.monitor(meterRegistry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass()));
            } else if (string.equals("java.util.concurrent.Executors$FinalizableDelegatedExecutorService")) {
                this.monitor(meterRegistry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass().getSuperclass()));
            } else {
                log.warn("Failed to bind as {} is unsupported.", (Object)string);
            }
        } else {
            log.warn("Failed to bind as {} is unsupported or reflective access is not allowed.", (Object)string);
        }
    }

    @Nullable
    private ThreadPoolExecutor unwrapThreadPoolExecutor(ExecutorService executorService, Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("e");
            field.setAccessible(true);
            return (ThreadPoolExecutor)field.get(executorService);
        }
        catch (IllegalAccessException | NoSuchFieldException | RuntimeException exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            log.info("Cannot unwrap ThreadPoolExecutor for monitoring from {} due to {}: {}", clazz.getName(), exception2.getClass().getName(), exception2.getMessage());
            return null;
        }
    }

    private void monitor(MeterRegistry meterRegistry, @Nullable ThreadPoolExecutor threadPoolExecutor2) {
        if (threadPoolExecutor2 == null) {
            return;
        }
        FunctionCounter.builder(this.metricPrefix + "executor.completed", threadPoolExecutor2, ThreadPoolExecutor::getCompletedTaskCount).tags(this.tags).description("The approximate total number of tasks that have completed execution").baseUnit("tasks").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.active", threadPoolExecutor2, ThreadPoolExecutor::getActiveCount).tags(this.tags).description("The approximate number of threads that are actively executing tasks").baseUnit("threads").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.queued", threadPoolExecutor2, threadPoolExecutor -> threadPoolExecutor.getQueue().size()).tags(this.tags).description("The approximate number of tasks that are queued for execution").baseUnit("tasks").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.queue.remaining", threadPoolExecutor2, threadPoolExecutor -> threadPoolExecutor.getQueue().remainingCapacity()).tags(this.tags).description("The number of additional elements that this queue can ideally accept without blocking").baseUnit("tasks").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.pool.size", threadPoolExecutor2, ThreadPoolExecutor::getPoolSize).tags(this.tags).description("The current number of threads in the pool").baseUnit("threads").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.pool.core", threadPoolExecutor2, ThreadPoolExecutor::getCorePoolSize).tags(this.tags).description("The core number of threads for the pool").baseUnit("threads").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.pool.max", threadPoolExecutor2, ThreadPoolExecutor::getMaximumPoolSize).tags(this.tags).description("The maximum allowed number of threads in the pool").baseUnit("threads").register(meterRegistry);
    }

    private void monitor(MeterRegistry meterRegistry, ForkJoinPool forkJoinPool) {
        FunctionCounter.builder(this.metricPrefix + "executor.steals", forkJoinPool, ForkJoinPool::getStealCount).tags(this.tags).description("Estimate of the total number of tasks stolen from one thread's work queue by another. The reported value underestimates the actual total number of steals when the pool is not quiescent").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.queued", forkJoinPool, ForkJoinPool::getQueuedTaskCount).tags(this.tags).description("An estimate of the total number of tasks currently held in queues by worker threads").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.active", forkJoinPool, ForkJoinPool::getActiveThreadCount).tags(this.tags).description("An estimate of the number of threads that are currently stealing or executing tasks").register(meterRegistry);
        Gauge.builder(this.metricPrefix + "executor.running", forkJoinPool, ForkJoinPool::getRunningThreadCount).tags(this.tags).description("An estimate of the number of worker threads that are not blocked waiting to join tasks or for other managed synchronization threads").register(meterRegistry);
    }

    public static void disableIllegalReflectiveAccess() {
        allowIllegalReflectiveAccess = false;
    }
}

