/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.composite;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.AbstractCompositeMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.noop.NoopTimeGauge;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

class CompositeTimeGauge<T>
extends AbstractCompositeMeter<TimeGauge>
implements TimeGauge {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;
    private final TimeUnit fUnit;

    CompositeTimeGauge(Meter.Id id, @Nullable T t2, TimeUnit timeUnit, ToDoubleFunction<T> toDoubleFunction) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.f = toDoubleFunction;
        this.fUnit = timeUnit;
    }

    @Override
    public double value() {
        return ((TimeGauge)this.firstChild()).value();
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return ((TimeGauge)this.firstChild()).baseTimeUnit();
    }

    @Override
    TimeGauge newNoopMeter() {
        return new NoopTimeGauge(this.getId());
    }

    @Override
    TimeGauge registerNewMeter(MeterRegistry meterRegistry) {
        Object t2 = this.ref.get();
        if (t2 == null) {
            return null;
        }
        return TimeGauge.builder(this.getId().getName(), t2, this.fUnit, this.f).tags(this.getId().getTagsAsIterable()).description(this.getId().getDescription()).register(meterRegistry);
    }
}

