/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.composite;

import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.composite.AbstractCompositeMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.imm.core.instrument.noop.NoopTimer;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

class CompositeTimer
extends AbstractCompositeMeter<Timer>
implements Timer {
    private final Clock clock;
    private final DistributionStatisticConfig distributionStatisticConfig;
    private final PauseDetector pauseDetector;

    CompositeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(id);
        this.clock = clock;
        this.distributionStatisticConfig = distributionStatisticConfig;
        this.pauseDetector = pauseDetector;
    }

    @Override
    public void record(long l2, TimeUnit timeUnit) {
        for (Timer timer : this.getChildren()) {
            timer.record(l2, timeUnit);
        }
    }

    @Override
    public void record(Duration duration) {
        for (Timer timer : this.getChildren()) {
            timer.record(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> supplier) {
        long l2 = this.clock.monotonicTime();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean record(BooleanSupplier booleanSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            boolean bl2 = booleanSupplier.getAsBoolean();
            return bl2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int record(IntSupplier intSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            int n2 = intSupplier.getAsInt();
            return n2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long record(LongSupplier longSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            long l3 = longSupplier.getAsLong();
            return l3;
        }
        finally {
            long l4 = this.clock.monotonicTime();
            this.record(l4 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double record(DoubleSupplier doubleSupplier) {
        long l2 = this.clock.monotonicTime();
        try {
            double d2 = doubleSupplier.getAsDouble();
            return d2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> callable) throws Exception {
        long l2 = this.clock.monotonicTime();
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable runnable) {
        long l2 = this.clock.monotonicTime();
        try {
            runnable.run();
        }
        finally {
            long l3 = this.clock.monotonicTime();
            this.record(l3 - l2, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return ((Timer)this.firstChild()).count();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        return ((Timer)this.firstChild()).totalTime(timeUnit);
    }

    @Override
    public double max(TimeUnit timeUnit) {
        return ((Timer)this.firstChild()).max(timeUnit);
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        return ((Timer)this.firstChild()).takeSnapshot();
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return ((Timer)this.firstChild()).baseTimeUnit();
    }

    @Override
    Timer newNoopMeter() {
        return new NoopTimer(this.getId());
    }

    @Override
    Timer registerNewMeter(MeterRegistry meterRegistry) {
        Timer.Builder builder = ((Timer.Builder)Timer.builder(this.getId().getName()).tags((Iterable)this.getId().getTagsAsIterable())).description(this.getId().getDescription()).maximumExpectedValue(Duration.ofNanos(this.distributionStatisticConfig.getMaximumExpectedValueAsDouble().longValue())).minimumExpectedValue(Duration.ofNanos(this.distributionStatisticConfig.getMinimumExpectedValueAsDouble().longValue())).publishPercentiles(this.distributionStatisticConfig.getPercentiles()).publishPercentileHistogram(this.distributionStatisticConfig.isPercentileHistogram()).distributionStatisticBufferLength(this.distributionStatisticConfig.getBufferLength()).distributionStatisticExpiry(this.distributionStatisticConfig.getExpiry()).percentilePrecision(this.distributionStatisticConfig.getPercentilePrecision()).pauseDetector(this.pauseDetector);
        double[] dArray = this.distributionStatisticConfig.getServiceLevelObjectiveBoundaries();
        if (dArray != null) {
            Duration[] durationArray = new Duration[dArray.length];
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                durationArray[i2] = Duration.ofNanos((long)dArray[i2]);
            }
            builder = builder.serviceLevelObjectives(durationArray);
        }
        return builder.register(meterRegistry);
    }
}

