/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.dropwizard;

import com.codahale.metrics.Timer;
import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowMax;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class DropwizardTimer
extends AbstractTimer {
    private final Timer impl;
    private final AtomicLong totalTime = new AtomicLong();
    private final TimeWindowMax max;

    DropwizardTimer(Meter.Id id, Timer timer, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(id, clock, distributionStatisticConfig, pauseDetector, TimeUnit.MILLISECONDS, false);
        this.impl = timer;
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(long l2, TimeUnit timeUnit) {
        if (l2 >= 0L) {
            this.impl.update(l2, timeUnit);
            long l3 = TimeUnit.NANOSECONDS.convert(l2, timeUnit);
            this.max.record(l3, TimeUnit.NANOSECONDS);
            this.totalTime.addAndGet(l3);
        }
    }

    @Override
    public long count() {
        return this.impl.getCount();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.totalTime.get(), timeUnit);
    }

    @Override
    public double max(TimeUnit timeUnit) {
        return this.max.poll(timeUnit);
    }
}

