/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.observation;

import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.observation.GlobalObservationConvention;
import com.contrastsecurity.thirdparty.imm.observation.NoopObservationRegistry;
import com.contrastsecurity.thirdparty.imm.observation.Observation;
import com.contrastsecurity.thirdparty.imm.observation.ObservationConvention;
import com.contrastsecurity.thirdparty.imm.observation.ObservationFilter;
import com.contrastsecurity.thirdparty.imm.observation.ObservationHandler;
import com.contrastsecurity.thirdparty.imm.observation.ObservationPredicate;
import com.contrastsecurity.thirdparty.imm.observation.SimpleObservationRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public interface ObservationRegistry {
    public static final ObservationRegistry NOOP = NoopObservationRegistry.INSTANCE;

    public static ObservationRegistry create() {
        return new SimpleObservationRegistry();
    }

    @Nullable
    public Observation getCurrentObservation();

    @Nullable
    public Observation.Scope getCurrentObservationScope();

    public void setCurrentObservationScope(@Nullable Observation.Scope var1);

    public ObservationConfig observationConfig();

    default public boolean isNoop() {
        return this == NOOP;
    }

    public static class ObservationConfig {
        private final List<ObservationHandler<?>> observationHandlers = new CopyOnWriteArrayList();
        private final List<ObservationPredicate> observationPredicates = new CopyOnWriteArrayList<ObservationPredicate>();
        private final List<ObservationConvention<?>> observationConventions = new CopyOnWriteArrayList();
        private final List<ObservationFilter> observationFilters = new CopyOnWriteArrayList<ObservationFilter>();

        public ObservationConfig observationHandler(ObservationHandler<?> observationHandler) {
            this.observationHandlers.add(observationHandler);
            return this;
        }

        public ObservationConfig observationPredicate(ObservationPredicate observationPredicate) {
            this.observationPredicates.add(observationPredicate);
            return this;
        }

        public ObservationConfig observationFilter(ObservationFilter observationFilter) {
            this.observationFilters.add(observationFilter);
            return this;
        }

        public ObservationConfig observationConvention(GlobalObservationConvention<?> globalObservationConvention) {
            this.observationConventions.add(globalObservationConvention);
            return this;
        }

        <T extends Observation.Context> ObservationConvention<T> getObservationConvention(T t2, ObservationConvention<T> observationConvention) {
            for (ObservationConvention<?> observationConvention2 : this.observationConventions) {
                if (!observationConvention2.supportsContext(t2)) continue;
                return observationConvention2;
            }
            return Objects.requireNonNull(observationConvention, "Default ObservationConvention must not be null");
        }

        boolean isObservationEnabled(String string, @Nullable Observation.Context context) {
            for (ObservationPredicate observationPredicate : this.observationPredicates) {
                if (observationPredicate.test(string, context)) continue;
                return false;
            }
            return true;
        }

        Collection<ObservationHandler<?>> getObservationHandlers() {
            return this.observationHandlers;
        }

        Collection<ObservationFilter> getObservationFilters() {
            return this.observationFilters;
        }

        Collection<ObservationConvention<?>> getObservationConventions() {
            return this.observationConventions;
        }
    }
}

