/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.traces;

import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.iot.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.InstrumentationScopeMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.ResourceMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.traces.InstrumentationScopeSpansMarshaler;
import com.contrastsecurity.thirdparty.iot.exporter.internal.otlp.traces.SpanMarshaler;
import com.contrastsecurity.thirdparty.iot.proto.trace.v1.internal.ResourceSpans;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.resources.Resource;
import com.contrastsecurity.thirdparty.iot.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceSpansMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrlUtf8;
    private final InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers;

    public static ResourceSpansMarshaler[] create(Collection<SpanData> collection) {
        Map<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> map = ResourceSpansMarshaler.groupByResourceAndScope(collection);
        ResourceSpansMarshaler[] resourceSpansMarshalerArray = new ResourceSpansMarshaler[map.size()];
        int n2 = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> entry : map.entrySet()) {
            InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalerArray = new InstrumentationScopeSpansMarshaler[entry.getValue().size()];
            int n3 = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<SpanMarshaler>> entry2 : entry.getValue().entrySet()) {
                instrumentationScopeSpansMarshalerArray[n3++] = new InstrumentationScopeSpansMarshaler(InstrumentationScopeMarshaler.create(entry2.getKey()), MarshalerUtil.toBytes(entry2.getKey().getSchemaUrl()), entry2.getValue());
            }
            resourceSpansMarshalerArray[n2++] = new ResourceSpansMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationScopeSpansMarshalerArray);
        }
        return resourceSpansMarshalerArray;
    }

    ResourceSpansMarshaler(ResourceMarshaler resourceMarshaler, byte[] byArray, InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalerArray) {
        super(ResourceSpansMarshaler.calculateSize(resourceMarshaler, byArray, instrumentationScopeSpansMarshalerArray));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrlUtf8 = byArray;
        this.instrumentationScopeSpansMarshalers = instrumentationScopeSpansMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeMessage(ResourceSpans.RESOURCE, this.resourceMarshaler);
        serializer.serializeRepeatedMessage(ResourceSpans.SCOPE_SPANS, this.instrumentationScopeSpansMarshalers);
        serializer.serializeString(ResourceSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] byArray, InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeMessage(ResourceSpans.RESOURCE, resourceMarshaler);
        n2 += MarshalerUtil.sizeBytes(ResourceSpans.SCHEMA_URL, byArray);
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceSpans.SCOPE_SPANS, (Marshaler[])instrumentationScopeSpansMarshalerArray);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> groupByResourceAndScope(Collection<SpanData> collection) {
        return MarshalerUtil.groupByResourceAndScope(collection, SpanData::getResource, SpanData::getInstrumentationScopeInfo, SpanMarshaler::create);
    }
}

