/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.queues;

import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.queues.ConcurrentCircularArrayQueueL0Pad;
import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.queues.IndexedQueueSizeUtil;
import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.queues.QueueProgressIndicators;
import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.queues.SupportsIterator;
import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.util.Pow2;
import com.contrastsecurity.thirdparty.iot.internal.shaded.jctools.util.UnsafeRefArrayAccess;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E>
implements IndexedQueueSizeUtil.IndexedQueue,
MessagePassingQueue<E>,
QueueProgressIndicators,
SupportsIterator {
    protected final long mask;
    protected final E[] buffer;

    ConcurrentCircularArrayQueue(int n2) {
        int n3 = Pow2.roundToPowerOfTwo(n2);
        this.mask = n3 - 1;
        this.buffer = UnsafeRefArrayAccess.allocateRefArray(n3);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public int capacity() {
        return (int)(this.mask + 1L);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public Iterator<E> iterator() {
        long l2 = this.lvConsumerIndex();
        long l3 = this.lvProducerIndex();
        return new WeakIterator<E>(l2, l3, this.mask, this.buffer);
    }

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private final long mask;
        private final E[] buffer;
        private long nextIndex;
        private E nextElement;

        WeakIterator(long l2, long l3, long l4, E[] EArray) {
            this.nextIndex = l2;
            this.pIndex = l3;
            this.mask = l4;
            this.buffer = EArray;
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e2 = this.nextElement;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e2;
        }

        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                long l2;
                E e2;
                if ((e2 = UnsafeRefArrayAccess.lvRefElement(this.buffer, l2 = UnsafeRefArrayAccess.calcCircularRefElementOffset(this.nextIndex++, this.mask))) == null) continue;
                return e2;
            }
            return null;
        }
    }
}

