/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk;

import com.contrastsecurity.thirdparty.iot.api.GlobalOpenTelemetry;
import com.contrastsecurity.thirdparty.iot.context.propagation.ContextPropagators;
import com.contrastsecurity.thirdparty.iot.sdk.OpenTelemetrySdk;
import com.contrastsecurity.thirdparty.iot.sdk.logs.SdkLoggerProvider;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkMeterProvider;
import com.contrastsecurity.thirdparty.iot.sdk.trace.SdkTracerProvider;
import javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;
    @Nullable
    private SdkLoggerProvider loggerProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider sdkTracerProvider) {
        this.tracerProvider = sdkTracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider sdkMeterProvider) {
        this.meterProvider = sdkMeterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setLoggerProvider(SdkLoggerProvider sdkLoggerProvider) {
        this.loggerProvider = sdkLoggerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators contextPropagators) {
        this.propagators = contextPropagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk openTelemetrySdk = this.build();
        GlobalOpenTelemetry.set(openTelemetrySdk);
        return openTelemetrySdk;
    }

    public OpenTelemetrySdk build() {
        SdkLoggerProvider sdkLoggerProvider;
        SdkMeterProvider sdkMeterProvider;
        SdkTracerProvider sdkTracerProvider = this.tracerProvider;
        if (sdkTracerProvider == null) {
            sdkTracerProvider = SdkTracerProvider.builder().build();
        }
        if ((sdkMeterProvider = this.meterProvider) == null) {
            sdkMeterProvider = SdkMeterProvider.builder().build();
        }
        if ((sdkLoggerProvider = this.loggerProvider) == null) {
            sdkLoggerProvider = SdkLoggerProvider.builder().build();
        }
        return new OpenTelemetrySdk(sdkTracerProvider, sdkMeterProvider, sdkLoggerProvider, this.propagators);
    }
}

