/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.internal;

import com.contrastsecurity.thirdparty.iot.sdk.common.Clock;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiter {
    private final Clock clock;
    private final double creditsPerNanosecond;
    private final long maxBalance;
    private final AtomicLong currentBalance;

    public RateLimiter(double d2, double d3, Clock clock) {
        this.clock = clock;
        this.creditsPerNanosecond = d2 / 1.0E9;
        this.maxBalance = (long)(d3 / this.creditsPerNanosecond);
        this.currentBalance = new AtomicLong(clock.nanoTime() - this.maxBalance);
    }

    public boolean trySpend(double d2) {
        long l2;
        long l3;
        long l4;
        long l5 = (long)(d2 / this.creditsPerNanosecond);
        do {
            l4 = this.currentBalance.get();
            l3 = this.clock.nanoTime();
            long l6 = l3 - l4;
            if (l6 > this.maxBalance) {
                l6 = this.maxBalance;
            }
            if ((l2 = l6 - l5) >= 0L) continue;
            return false;
        } while (!this.currentBalance.compareAndSet(l4, l3 - l2));
        return true;
    }
}

