/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.logs;

import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.logs.LogRecordBuilder;
import com.contrastsecurity.thirdparty.iot.api.logs.Severity;
import com.contrastsecurity.thirdparty.iot.api.trace.Span;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.iot.sdk.internal.AttributesMap;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogLimits;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LoggerSharedState;
import com.contrastsecurity.thirdparty.iot.sdk.logs.SdkReadWriteLogRecord;
import com.contrastsecurity.thirdparty.iot.sdk.logs.data.Body;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SdkLogRecordBuilder
implements LogRecordBuilder {
    private final LoggerSharedState loggerSharedState;
    private final LogLimits logLimits;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private long timestampEpochNanos;
    private long observedTimestampEpochNanos;
    @Nullable
    private Context context;
    private Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    private String severityText;
    private Body body = Body.empty();
    @Nullable
    private AttributesMap attributes;

    SdkLogRecordBuilder(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.loggerSharedState = loggerSharedState;
        this.logLimits = loggerSharedState.getLogLimits();
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    @Override
    public SdkLogRecordBuilder setTimestamp(long l2, TimeUnit timeUnit) {
        this.timestampEpochNanos = timeUnit.toNanos(l2);
        return this;
    }

    @Override
    public SdkLogRecordBuilder setTimestamp(Instant instant) {
        this.timestampEpochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    @Override
    public LogRecordBuilder setObservedTimestamp(long l2, TimeUnit timeUnit) {
        this.observedTimestampEpochNanos = timeUnit.toNanos(l2);
        return this;
    }

    @Override
    public LogRecordBuilder setObservedTimestamp(Instant instant) {
        this.observedTimestampEpochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    @Override
    public SdkLogRecordBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public SdkLogRecordBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public SdkLogRecordBuilder setSeverityText(String string) {
        this.severityText = string;
        return this;
    }

    @Override
    public SdkLogRecordBuilder setBody(String string) {
        this.body = Body.string(string);
        return this;
    }

    @Override
    public <T> SdkLogRecordBuilder setAttribute(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null || attributeKey.getKey().isEmpty() || t2 == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
        }
        this.attributes.put(attributeKey, t2);
        return this;
    }

    @Override
    public void emit() {
        if (this.loggerSharedState.hasBeenShutdown()) {
            return;
        }
        Context context = this.context == null ? Context.current() : this.context;
        long l2 = this.observedTimestampEpochNanos == 0L ? this.loggerSharedState.getClock().now() : this.observedTimestampEpochNanos;
        this.loggerSharedState.getLogRecordProcessor().onEmit(context, SdkReadWriteLogRecord.create(this.loggerSharedState.getLogLimits(), this.loggerSharedState.getResource(), this.instrumentationScopeInfo, this.timestampEpochNanos, l2, Span.fromContext(context).getSpanContext(), this.severity, this.severityText, this.body, this.attributes));
    }
}

