/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.metrics.internal;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkMeterProvider;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.SdkMeterProviderBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.ViewBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.export.MetricReader;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.export.CardinalityLimitSelector;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.view.AttributesProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.metrics.internal.view.StringPredicates;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public final class SdkMeterProviderUtil {
    private SdkMeterProviderUtil() {
    }

    public static void setExemplarFilter(SdkMeterProviderBuilder sdkMeterProviderBuilder, ExemplarFilter exemplarFilter) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setExemplarFilter", ExemplarFilter.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, exemplarFilter);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalStateException("Error calling setExemplarFilter on SdkMeterProviderBuilder", reflectiveOperationException2);
        }
    }

    public static void registerMetricReaderWithCardinalitySelector(SdkMeterProviderBuilder sdkMeterProviderBuilder, MetricReader metricReader, CardinalityLimitSelector cardinalityLimitSelector) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("registerMetricReader", MetricReader.class, CardinalityLimitSelector.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, metricReader, cardinalityLimitSelector);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalStateException("Error calling addMetricReader on SdkMeterProviderBuilder", reflectiveOperationException2);
        }
    }

    public static void appendFilteredBaggageAttributes(ViewBuilder viewBuilder, Predicate<String> predicate) {
        SdkMeterProviderUtil.addAttributesProcessor(viewBuilder, AttributesProcessor.appendBaggageByKeyName(predicate));
    }

    public static void appendAllBaggageAttributes(ViewBuilder viewBuilder) {
        SdkMeterProviderUtil.appendFilteredBaggageAttributes(viewBuilder, StringPredicates.ALL);
    }

    private static void addAttributesProcessor(ViewBuilder viewBuilder, AttributesProcessor attributesProcessor) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("addAttributesProcessor", AttributesProcessor.class);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, attributesProcessor);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalStateException("Error adding AttributesProcessor to ViewBuilder", reflectiveOperationException2);
        }
    }

    public static void setCardinalityLimit(ViewBuilder viewBuilder, int n2) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("setCardinalityLimit", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, n2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalStateException("Error setting cardinalityLimit on ViewBuilder", reflectiveOperationException2);
        }
    }

    public static void resetForTest(SdkMeterProvider sdkMeterProvider) {
        try {
            Method method = SdkMeterProvider.class.getDeclaredMethod("resetForTest", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProvider, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            Throwables.throwIfCritical(reflectiveOperationException);
            ReflectiveOperationException reflectiveOperationException2 = reflectiveOperationException;
            throw new IllegalStateException("Error calling resetForTest on SdkMeterProvider", reflectiveOperationException2);
        }
    }
}

