/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.resources;

import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.cggl.auto.value.AutoValue;
import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.common.AttributesBuilder;
import com.contrastsecurity.thirdparty.iot.api.internal.StringUtils;
import com.contrastsecurity.thirdparty.iot.api.internal.Utils;
import com.contrastsecurity.thirdparty.iot.sdk.resources.AutoValue_Resource;
import com.contrastsecurity.thirdparty.iot.sdk.resources.ResourceBuilder;
import com.contrastsecurity.thirdparty.iot.semconv.resource.attributes.ResourceAttributes;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final e logger = e.a(Resource.class.getName());
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Attributes.empty());
    private static final Resource TELEMETRY_SDK;
    private static final Resource MANDATORY;
    private static final Resource DEFAULT;

    public static Resource getDefault() {
        return DEFAULT;
    }

    public static Resource empty() {
        return EMPTY;
    }

    public static Resource create(Attributes attributes) {
        return Resource.create(attributes, null);
    }

    public static Resource create(Attributes attributes, @Nullable String string) {
        Resource.checkAttributes(Objects.requireNonNull(attributes, "attributes"));
        return new AutoValue_Resource(string, attributes);
    }

    @Nullable
    public abstract String getSchemaUrl();

    public abstract Attributes getAttributes();

    @Nullable
    public <T> T getAttribute(AttributeKey<T> attributeKey) {
        return this.getAttributes().get(attributeKey);
    }

    public Resource merge(@Nullable Resource resource) {
        if (resource == null || resource == EMPTY) {
            return this;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.putAll(this.getAttributes());
        attributesBuilder.putAll(resource.getAttributes());
        if (resource.getSchemaUrl() == null) {
            return Resource.create(attributesBuilder.build(), this.getSchemaUrl());
        }
        if (this.getSchemaUrl() == null) {
            return Resource.create(attributesBuilder.build(), resource.getSchemaUrl());
        }
        if (!resource.getSchemaUrl().equals(this.getSchemaUrl())) {
            logger.d("Attempting to merge Resources with different schemaUrls. The resulting Resource will have no schemaUrl assigned. Schema 1: " + this.getSchemaUrl() + " Schema 2: " + resource.getSchemaUrl());
            return Resource.create(attributesBuilder.build(), null);
        }
        return Resource.create(attributesBuilder.build(), this.getSchemaUrl());
    }

    private static void checkAttributes(Attributes attributes) {
        attributes.forEach((attributeKey, object) -> {
            Utils.checkArgument(Resource.isValidAndNotEmpty(attributeKey), "Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            Objects.requireNonNull(object, "Attribute value should be a ASCII string with a length not exceed 255 characters.");
        });
    }

    private static boolean isValid(String string) {
        return string.length() <= 255 && StringUtils.isPrintableString(string);
    }

    private static boolean isValidAndNotEmpty(AttributeKey<?> attributeKey) {
        return !attributeKey.getKey().isEmpty() && Resource.isValid(attributeKey.getKey());
    }

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public ResourceBuilder toBuilder() {
        ResourceBuilder resourceBuilder = Resource.builder().putAll(this);
        if (this.getSchemaUrl() != null) {
            resourceBuilder.setSchemaUrl(this.getSchemaUrl());
        }
        return resourceBuilder;
    }

    Resource() {
    }

    static {
        MANDATORY = Resource.create(Attributes.of(ResourceAttributes.SERVICE_NAME, "unknown_service:java"));
        TELEMETRY_SDK = Resource.create(Attributes.builder().put(ResourceAttributes.TELEMETRY_SDK_NAME, "opentelemetry").put(ResourceAttributes.TELEMETRY_SDK_LANGUAGE, "java").put(ResourceAttributes.TELEMETRY_SDK_VERSION, "1.29.0").build());
        DEFAULT = MANDATORY.merge(TELEMETRY_SDK);
    }
}

