/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jrgx.util.io;

import com.contrastsecurity.thirdparty.jrgx.MatchResult;
import com.contrastsecurity.thirdparty.jrgx.Pattern;
import com.contrastsecurity.thirdparty.jrgx.RETokenizer;
import com.contrastsecurity.thirdparty.jrgx.Replacer;
import com.contrastsecurity.thirdparty.jrgx.Substitution;
import com.contrastsecurity.thirdparty.jrgx.TextBuffer;
import com.contrastsecurity.thirdparty.jrgx.util.io.PathElementEnumerator;
import com.contrastsecurity.thirdparty.jrgx.util.io.PathElementMask;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class PathPattern
extends Pattern {
    private static final int RESERVED = 1;
    private static int GRP_NO = 2;
    private static final int ANY_G = GRP_NO++;
    private static final int FS_G = GRP_NO++;
    private static final int STAR_G = GRP_NO++;
    private static final int QMARK_G = GRP_NO++;
    private static final int SPCHAR_G = GRP_NO++;
    private static final int NONROOT_G = GRP_NO++;
    private static final String fsChars = "/\\" + File.separator;
    private static final String fsClass = "[" + fsChars + "]";
    private static final String nfsClass = "[^" + fsChars + "]";
    private static final String fName = nfsClass + "+";
    private static final Pattern fs = new Pattern(fsClass);
    private static final Pattern spCharPattern = new Pattern(PathPattern.grp(NONROOT_G, "^(?!" + fsClass + ")") + "|" + PathPattern.grp(ANY_G, fsClass + "?\\*\\*" + fsClass + "?") + "|" + PathPattern.grp(FS_G, fsClass) + "|" + PathPattern.grp(STAR_G, "\\*") + "|" + PathPattern.grp(QMARK_G, "\\?") + "|" + PathPattern.grp(SPCHAR_G, "[.()\\{\\}+|^$\\[\\]\\\\]"));
    private static final Replacer spCharProcessor = new Replacer(spCharPattern, new Substitution(){

        @Override
        public void appendSubstitution(MatchResult matchResult, TextBuffer textBuffer) {
            if (matchResult.isCaptured(FS_G)) {
                textBuffer.append(fsClass);
            } else if (matchResult.isCaptured(ANY_G)) {
                textBuffer.append("(?:(?:");
                textBuffer.append(fsClass);
                textBuffer.append("|^)((?:");
                textBuffer.append(fName);
                textBuffer.append("(?:");
                textBuffer.append(fsClass);
                textBuffer.append(fName);
                textBuffer.append(")*)?))?");
                textBuffer.append("(?:");
                textBuffer.append(fsClass);
                textBuffer.append("|$)");
            } else if (matchResult.isCaptured(STAR_G)) {
                textBuffer.append("(");
                textBuffer.append(nfsClass);
                textBuffer.append("*)");
            } else if (matchResult.isCaptured(QMARK_G)) {
                textBuffer.append("(");
                textBuffer.append(nfsClass);
                textBuffer.append(")");
            } else if (matchResult.isCaptured(SPCHAR_G)) {
                textBuffer.append("\\");
                matchResult.getGroup(SPCHAR_G, textBuffer);
            } else if (matchResult.isCaptured(NONROOT_G)) {
                textBuffer.append("(?:\\.");
                textBuffer.append(fsClass);
                textBuffer.append(")?");
            }
        }
    });
    private String str;
    private String root;
    private File rootf;
    private PathElementMask queue;
    private PathElementMask last;

    private static final String grp(int n2, String string) {
        return "({" + n2 + "}" + string + ")";
    }

    public PathPattern(String string) {
        this(string, 0);
    }

    public PathPattern(String string, boolean bl2) {
        this(string, bl2 ? 1 : 0);
    }

    public PathPattern(String string, int n2) {
        this(null, string, n2);
    }

    public PathPattern(File file, String string, boolean bl2) {
        this(null, string, bl2 ? 1 : 0);
    }

    public PathPattern(File file, String string, int n2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("empty path not allowed");
        }
        this.str = string;
        RETokenizer rETokenizer = new RETokenizer(fs.matcher(string), true);
        String string2 = rETokenizer.nextToken();
        if (string2.equals("")) {
            if (file != null) {
                this.rootf = file;
            } else {
                this.root = "/";
            }
        } else {
            if (file != null) {
                this.rootf = file;
            } else {
                this.root = ".";
            }
            this.addElement(PathPattern.newMask(string2, n2, rETokenizer.hasMore()));
        }
        while (rETokenizer.hasMore()) {
            string2 = rETokenizer.nextToken();
            boolean bl2 = rETokenizer.hasMore();
            if (string2.equals("")) {
                if (!bl2) break;
                throw new IllegalArgumentException("\"//\" not allowed");
            }
            this.addElement(PathPattern.newMask(string2, n2, bl2));
        }
        this.compile(spCharProcessor.replace(string), n2);
    }

    private void addElement(PathElementMask pathElementMask) {
        if (this.queue == null) {
            this.queue = this.last = pathElementMask;
        } else {
            this.last = this.last.next = pathElementMask;
        }
    }

    public Enumeration enumerateFiles() {
        PathElementEnumerator pathElementEnumerator = this.queue.newEnumerator();
        pathElementEnumerator.setDir(this.rootf != null ? this.rootf : new File(this.root));
        return pathElementEnumerator;
    }

    public File[] files() {
        Enumeration enumeration = this.enumerateFiles();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] names() {
        return null;
    }

    public File directory() {
        return null;
    }

    private static PathElementMask newMask(String string, int n2, boolean bl2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Error: empty path element not allowed");
        }
        if (string.indexOf(42) < 0 && string.indexOf(63) < 0) {
            if ((n2 & 1) == 0 || string.indexOf(58) >= 0) {
                return PathElementMask.fixedMask(string, bl2);
            }
            return PathElementMask.regularMask(string, n2, bl2);
        }
        if (string.equals("*")) {
            return PathElementMask.anyFile(bl2);
        }
        if (string.equals("**")) {
            return PathElementMask.anyPath(bl2);
        }
        return PathElementMask.regularMask(string, n2, bl2);
    }

    @Override
    public String toString() {
        return this.str;
    }
}

