/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nsjsqlp.statement.alter;

import com.contrastsecurity.thirdparty.nsjsqlp.statement.alter.AlterOperation;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.alter.ConstraintState;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.create.table.ColDataType;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.create.table.Index;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.PlainSelect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AlterExpression {
    private AlterOperation operation;
    private String columnName;
    private List<ColumnDataType> colDataTypeList;
    private List<String> pkColumns;
    private List<String> ukColumns;
    private String ukName;
    private Index index = null;
    private String constraintName;
    private boolean onDeleteRestrict;
    private boolean onDeleteSetNull;
    private boolean onDeleteCascade;
    private List<String> fkColumns;
    private String fkSourceTable;
    private List<String> fkSourceColumns;
    private List<ConstraintState> constraints;

    public AlterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterOperation alterOperation) {
        this.operation = alterOperation;
    }

    public boolean isOnDeleteCascade() {
        return this.onDeleteCascade;
    }

    public void setOnDeleteCascade(boolean bl2) {
        this.onDeleteCascade = bl2;
    }

    public boolean isOnDeleteRestrict() {
        return this.onDeleteRestrict;
    }

    public void setOnDeleteRestrict(boolean bl2) {
        this.onDeleteRestrict = bl2;
    }

    public boolean isOnDeleteSetNull() {
        return this.onDeleteSetNull;
    }

    public void setOnDeleteSetNull(boolean bl2) {
        this.onDeleteSetNull = bl2;
    }

    public List<String> getFkColumns() {
        return this.fkColumns;
    }

    public void setFkColumns(List<String> list) {
        this.fkColumns = list;
    }

    public String getFkSourceTable() {
        return this.fkSourceTable;
    }

    public void setFkSourceTable(String string) {
        this.fkSourceTable = string;
    }

    public List<ColumnDataType> getColDataTypeList() {
        return this.colDataTypeList;
    }

    public void addColDataType(String string, ColDataType colDataType) {
        this.addColDataType(new ColumnDataType(string, colDataType, null));
    }

    public void addColDataType(ColumnDataType columnDataType) {
        if (this.colDataTypeList == null) {
            this.colDataTypeList = new ArrayList<ColumnDataType>();
        }
        this.colDataTypeList.add(columnDataType);
    }

    public List<String> getFkSourceColumns() {
        return this.fkSourceColumns;
    }

    public void setFkSourceColumns(List<String> list) {
        this.fkSourceColumns = list;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(List<String> list) {
        this.pkColumns = list;
    }

    public List<String> getUkColumns() {
        return this.ukColumns;
    }

    public void setUkColumns(List<String> list) {
        this.ukColumns = list;
    }

    public String getUkName() {
        return this.ukName;
    }

    public void setUkName(String string) {
        this.ukName = string;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public List<ConstraintState> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<ConstraintState> list) {
        this.constraints = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.operation).append(" ");
        if (this.columnName != null) {
            stringBuilder.append("COLUMN ").append(this.columnName);
        } else if (this.getColDataTypeList() != null) {
            if (this.colDataTypeList.size() > 1) {
                stringBuilder.append("(");
            } else {
                stringBuilder.append("COLUMN ");
            }
            stringBuilder.append(PlainSelect.getStringList(this.colDataTypeList));
            if (this.colDataTypeList.size() > 1) {
                stringBuilder.append(")");
            }
        } else if (this.constraintName != null) {
            stringBuilder.append("CONSTRAINT ").append(this.constraintName);
        } else if (this.pkColumns != null) {
            stringBuilder.append("PRIMARY KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(')');
        } else if (this.ukColumns != null) {
            stringBuilder.append("UNIQUE KEY ").append(this.ukName).append(" (").append(PlainSelect.getStringList(this.ukColumns)).append(")");
        } else if (this.fkColumns != null) {
            stringBuilder.append("FOREIGN KEY (").append(PlainSelect.getStringList(this.fkColumns)).append(") REFERENCES ").append(this.fkSourceTable).append(" (").append(PlainSelect.getStringList(this.fkSourceColumns)).append(")");
            if (this.isOnDeleteCascade()) {
                stringBuilder.append(" ON DELETE CASCADE");
            } else if (this.isOnDeleteRestrict()) {
                stringBuilder.append(" ON DELETE RESTRICT");
            } else if (this.isOnDeleteSetNull()) {
                stringBuilder.append(" ON DELETE SET NULL");
            }
        } else if (this.index != null) {
            stringBuilder.append(this.index);
        }
        if (this.getConstraints() != null && !this.getConstraints().isEmpty()) {
            stringBuilder.append(' ').append(PlainSelect.getStringList(this.constraints, false, false));
        }
        return stringBuilder.toString();
    }

    public static class ColumnDataType {
        private final String columnName;
        private final ColDataType colDataType;
        private final List<String> columnSpecs;

        public ColumnDataType(String string, ColDataType colDataType, List<String> list) {
            this.columnName = string;
            this.colDataType = colDataType;
            this.columnSpecs = list;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public ColDataType getColDataType() {
            return this.colDataType;
        }

        public List<String> getColumnSpecs() {
            if (this.columnSpecs == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.columnSpecs);
        }

        public String toString() {
            return this.columnName + " " + this.colDataType + this.parametersToString();
        }

        private String parametersToString() {
            if (this.columnSpecs == null || this.columnSpecs.isEmpty()) {
                return "";
            }
            return " " + PlainSelect.getStringList(this.columnSpecs, false, false);
        }
    }
}

