/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.nsjsqlp.util.deparser;

import com.contrastsecurity.thirdparty.nsjsqlp.expression.Expression;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.ExpressionList;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.ItemsListVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.expression.operators.relational.MultiExpressionList;
import com.contrastsecurity.thirdparty.nsjsqlp.schema.Column;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.replace.Replace;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SelectVisitor;
import com.contrastsecurity.thirdparty.nsjsqlp.statement.select.SubSelect;
import java.util.Iterator;

public class ReplaceDeParser
implements ItemsListVisitor {
    private StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public ReplaceDeParser() {
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
    }

    public void deParse(Replace replace) {
        this.buffer.append("REPLACE ");
        if (replace.isUseIntoTables()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(replace.getTable().getFullyQualifiedName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                for (int i2 = 0; i2 < replace.getColumns().size(); ++i2) {
                    Column column = replace.getColumns().get(i2);
                    this.buffer.append(column.getFullyQualifiedName());
                    if (i2 >= replace.getColumns().size() - 1) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            for (int i3 = 0; i3 < replace.getColumns().size(); ++i3) {
                Column column = replace.getColumns().get(i3);
                this.buffer.append(column.getFullyQualifiedName()).append("=");
                Expression expression = replace.getExpressions().get(i3);
                expression.accept(this.expressionVisitor);
                if (i3 >= replace.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (replace.getItemsList() != null) {
            replace.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append("VALUES (");
        Iterator<Expression> iterator = expressionList.getExpressions().iterator();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            expression.accept(this.expressionVisitor);
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void visit(MultiExpressionList multiExpressionList) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

