/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.binary;

import com.contrastsecurity.thirdparty.oa4j.commons.codec.CodecPolicy;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.binary.BaseNCodec;

public class Base16
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 4;
    private static final int BYTES_PER_ENCODED_BLOCK = 2;
    private static final int BYTES_PER_UNENCODED_BLOCK = 1;
    private static final byte[] UPPER_CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] UPPER_CASE_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] LOWER_CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final byte[] LOWER_CASE_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final int MASK_4BITS = 15;
    private final byte[] decodeTable;
    private final byte[] encodeTable;

    public Base16() {
        this(false);
    }

    public Base16(boolean bl2) {
        this(bl2, DECODING_POLICY_DEFAULT);
    }

    public Base16(boolean bl2, CodecPolicy codecPolicy) {
        super(1, 2, 0, 0, (byte)61, codecPolicy);
        if (bl2) {
            this.encodeTable = LOWER_CASE_ENCODE_TABLE;
            this.decodeTable = LOWER_CASE_DECODE_TABLE;
        } else {
            this.encodeTable = UPPER_CASE_ENCODE_TABLE;
            this.decodeTable = UPPER_CASE_DECODE_TABLE;
        }
    }

    @Override
    void decode(byte[] byArray, int n2, int n3, BaseNCodec.Context context) {
        int n4;
        int n5;
        if (context.eof || n3 < 0) {
            context.eof = true;
            if (context.ibitWorkArea != 0) {
                this.validateTrailingCharacter();
            }
            return;
        }
        int n6 = (context.ibitWorkArea != 0 ? 1 : 0) + (n5 = Math.min(byArray.length - n2, n3));
        if (n6 == 1 && n6 == n5) {
            context.ibitWorkArea = this.decodeOctet(byArray[n2]) + 1;
            return;
        }
        int n7 = n6 % 2 == 0 ? n6 : n6 - 1;
        byte[] byArray2 = this.ensureBufferSize(n7 / 2, context);
        int n8 = 0;
        if (n5 < n6) {
            n4 = context.ibitWorkArea - 1 << 4;
            int n9 = n2++;
            n8 = 2;
            byArray2[context.pos++] = (byte)(n4 |= this.decodeOctet(byArray[n9]));
            context.ibitWorkArea = 0;
        }
        while (n8 < n7) {
            n4 = this.decodeOctet(byArray[n2++]) << 4;
            int n10 = n2++;
            n8 += 2;
            byArray2[context.pos++] = (byte)(n4 |= this.decodeOctet(byArray[n10]));
        }
        if (n8 < n5) {
            context.ibitWorkArea = this.decodeOctet(byArray[n8]) + 1;
        }
    }

    private int decodeOctet(byte by) {
        int n2 = -1;
        if ((by & 0xFF) < this.decodeTable.length) {
            n2 = this.decodeTable[by];
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("Invalid octet in encoded value: " + by);
        }
        return n2;
    }

    @Override
    void encode(byte[] byArray, int n2, int n3, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n3 < 0) {
            context.eof = true;
            return;
        }
        int n4 = n3 * 2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Input length exceeds maximum size for encoded data: " + n3);
        }
        byte[] byArray2 = this.ensureBufferSize(n4, context);
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            byte by = byArray[i2];
            int n6 = by >> 4 & 0xF;
            int n7 = by & 0xF;
            byArray2[context.pos++] = this.encodeTable[n6];
            byArray2[context.pos++] = this.encodeTable[n7];
        }
    }

    @Override
    public boolean isInAlphabet(byte by) {
        return (by & 0xFF) < this.decodeTable.length && this.decodeTable[by] != -1;
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character is a valid base 16 alphabetcharacter but not a possible encoding. Decoding requires at least two characters to create one byte.");
        }
    }
}

