/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.language;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.Resources;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class DaitchMokotoffSoundex
implements StringEncoder {
    private static final String COMMENT = "//";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String MULTILINE_COMMENT_END = "*/";
    private static final String MULTILINE_COMMENT_START = "/*";
    private static final String RESOURCE_FILE = "com/contrastsecurity/thirdparty/oa4j/commons/codec/language/dmrules.txt";
    private static final int MAX_LENGTH = 6;
    private static final Map<Character, List<Rule>> RULES;
    private static final Map<Character, Character> FOLDINGS;
    private final boolean folding;

    private static void parseRules(Scanner scanner, String string, Map<Character, List<Rule>> map, Map<Character, Character> map2) {
        int n2 = 0;
        boolean bl2 = false;
        while (scanner.hasNextLine()) {
            String string2;
            String string3;
            String[] stringArray;
            String string4;
            ++n2;
            String string5 = string4 = scanner.nextLine();
            if (bl2) {
                if (!string5.endsWith(MULTILINE_COMMENT_END)) continue;
                bl2 = false;
                continue;
            }
            if (string5.startsWith(MULTILINE_COMMENT_START)) {
                bl2 = true;
                continue;
            }
            int n3 = string5.indexOf(COMMENT);
            if (n3 >= 0) {
                string5 = string5.substring(0, n3);
            }
            if ((string5 = string5.trim()).length() == 0) continue;
            if (string5.contains("=")) {
                stringArray = string5.split("=");
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException("Malformed folding statement split into " + stringArray.length + " parts: " + string4 + " in " + string);
                }
                string3 = stringArray[0];
                string2 = stringArray[1];
                if (string3.length() != 1 || string2.length() != 1) {
                    throw new IllegalArgumentException("Malformed folding statement - patterns are not single characters: " + string4 + " in " + string);
                }
                map2.put(Character.valueOf(string3.charAt(0)), Character.valueOf(string2.charAt(0)));
                continue;
            }
            stringArray = string5.split("\\s+");
            if (stringArray.length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + stringArray.length + " parts: " + string4 + " in " + string);
            }
            try {
                string3 = DaitchMokotoffSoundex.stripQuotes(stringArray[0]);
                string2 = DaitchMokotoffSoundex.stripQuotes(stringArray[1]);
                String string6 = DaitchMokotoffSoundex.stripQuotes(stringArray[2]);
                String string7 = DaitchMokotoffSoundex.stripQuotes(stringArray[3]);
                Rule rule = new Rule(string3, string2, string6, string7);
                char c2 = rule.pattern.charAt(0);
                List<Rule> list = map.get(Character.valueOf(c2));
                if (list == null) {
                    list = new ArrayList<Rule>();
                    map.put(Character.valueOf(c2), list);
                }
                list.add(rule);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line '" + n2 + "' in " + string, illegalArgumentException);
            }
        }
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public DaitchMokotoffSoundex() {
        this(true);
    }

    public DaitchMokotoffSoundex(boolean bl2) {
        this.folding = bl2;
    }

    private String cleanup(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (Character.isWhitespace(c2)) continue;
            c2 = Character.toLowerCase(c2);
            if (this.folding && FOLDINGS.containsKey(Character.valueOf(c2))) {
                c2 = FOLDINGS.get(Character.valueOf(c2)).charValue();
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to DaitchMokotoffSoundex encode is not of type java.lang.String");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        if (string == null) {
            return null;
        }
        return this.soundex(string, false)[0];
    }

    public String soundex(String string) {
        String[] stringArray = this.soundex(string, true);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string2 : stringArray) {
            stringBuilder.append(string2);
            if (++n2 >= stringArray.length) continue;
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    private String[] soundex(String string, boolean bl2) {
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = this.cleanup(string);
        LinkedHashSet<Branch> linkedHashSet = new LinkedHashSet<Branch>();
        linkedHashSet.add(new Branch());
        int n3 = 0;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            n2 = string2.charAt(i2);
            if (Character.isWhitespace((char)n2)) continue;
            String string3 = string2.substring(i2);
            List<Rule> list = RULES.get(Character.valueOf((char)n2));
            if (list == null) continue;
            ArrayList<Branch> arrayList = bl2 ? new ArrayList<Branch>() : Collections.emptyList();
            for (Rule rule : list) {
                if (!rule.matches(string3)) continue;
                if (bl2) {
                    arrayList.clear();
                }
                String[] stringArray = rule.getReplacements(string3, n3 == 0);
                boolean bl3 = stringArray.length > 1 && bl2;
                block2: for (Branch branch : linkedHashSet) {
                    for (String string4 : stringArray) {
                        Branch branch2 = bl3 ? branch.createBranch() : branch;
                        boolean bl4 = n3 == 109 && n2 == 110 || n3 == 110 && n2 == 109;
                        branch2.processNextReplacement(string4, bl4);
                        if (!bl2) continue block2;
                        arrayList.add(branch2);
                    }
                }
                if (bl2) {
                    linkedHashSet.clear();
                    linkedHashSet.addAll(arrayList);
                }
                i2 += rule.getPatternLength() - 1;
                break;
            }
            n3 = n2;
        }
        String[] stringArray = new String[linkedHashSet.size()];
        n2 = 0;
        for (Branch branch : linkedHashSet) {
            branch.finish();
            stringArray[n2++] = branch.toString();
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Object object;
        Iterator<String> iterator;
        block10: {
            block11: {
                RULES = new HashMap<Character, List<Rule>>();
                FOLDINGS = new HashMap<Character, Character>();
                iterator = new Scanner(Resources.getInputStream(RESOURCE_FILE), "UTF-8");
                Throwable object2 = null;
                try {
                    DaitchMokotoffSoundex.parseRules((Scanner)iterator, RESOURCE_FILE, RULES, FOLDINGS);
                    if (iterator == null) break block10;
                    if (object2 == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2;
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable3 = throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable4) {
                        if (iterator == null) throw throwable4;
                        if (object2 == null) {
                            ((Scanner)iterator).close();
                            throw throwable4;
                        }
                        try {
                            ((Scanner)iterator).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable2) {
                            Throwables.throwIfCritical(throwable2);
                            Throwable throwable6 = throwable2;
                            object2.addSuppressed(throwable6);
                            throw throwable4;
                        }
                    }
                }
                try {
                    ((Scanner)iterator).close();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    object = throwable;
                    object2.addSuppressed((Throwable)object);
                }
                break block10;
            }
            ((Scanner)iterator).close();
        }
        iterator = RULES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)((Object)iterator.next());
            object = (List)entry.getValue();
            Collections.sort(object, new Comparator<Rule>(){

                @Override
                public int compare(Rule rule, Rule rule2) {
                    return rule2.getPatternLength() - rule.getPatternLength();
                }
            });
        }
    }

    private static final class Rule {
        private final String pattern;
        private final String[] replacementAtStart;
        private final String[] replacementBeforeVowel;
        private final String[] replacementDefault;

        protected Rule(String string, String string2, String string3, String string4) {
            this.pattern = string;
            this.replacementAtStart = string2.split("\\|");
            this.replacementBeforeVowel = string3.split("\\|");
            this.replacementDefault = string4.split("\\|");
        }

        public int getPatternLength() {
            return this.pattern.length();
        }

        public String[] getReplacements(String string, boolean bl2) {
            boolean bl3;
            if (bl2) {
                return this.replacementAtStart;
            }
            int n2 = this.getPatternLength();
            boolean bl4 = bl3 = n2 < string.length() ? this.isVowel(string.charAt(n2)) : false;
            if (bl3) {
                return this.replacementBeforeVowel;
            }
            return this.replacementDefault;
        }

        private boolean isVowel(char c2) {
            return c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u';
        }

        public boolean matches(String string) {
            return string.startsWith(this.pattern);
        }

        public String toString() {
            return String.format("%s=(%s,%s,%s)", this.pattern, Arrays.asList(this.replacementAtStart), Arrays.asList(this.replacementBeforeVowel), Arrays.asList(this.replacementDefault));
        }
    }

    private static final class Branch {
        private final StringBuilder builder = new StringBuilder();
        private String cachedString = null;
        private String lastReplacement = null;

        private Branch() {
        }

        public Branch createBranch() {
            Branch branch = new Branch();
            branch.builder.append(this.toString());
            branch.lastReplacement = this.lastReplacement;
            return branch;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Branch)) {
                return false;
            }
            return this.toString().equals(((Branch)object).toString());
        }

        public void finish() {
            while (this.builder.length() < 6) {
                this.builder.append('0');
                this.cachedString = null;
            }
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public void processNextReplacement(String string, boolean bl2) {
            boolean bl3;
            boolean bl4 = bl3 = this.lastReplacement == null || !this.lastReplacement.endsWith(string) || bl2;
            if (bl3 && this.builder.length() < 6) {
                this.builder.append(string);
                if (this.builder.length() > 6) {
                    this.builder.delete(6, this.builder.length());
                }
                this.cachedString = null;
            }
            this.lastReplacement = string;
        }

        public String toString() {
            if (this.cachedString == null) {
                this.cachedString = this.builder.toString();
            }
            return this.cachedString;
        }
    }
}

